/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.searchers.transformer.TextQueryValidator;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeTextFieldValidator
implements ClauseValidator {
    private static final Logger log = LoggerFactory.getLogger(FreeTextFieldValidator.class);
    @Deprecated
    public static final List<String> INVALID_FIRST_CHAR_LIST = ImmutableList.of((Object)"?", (Object)"*", (Object)"~", (Object)":", (Object)";", (Object)"!", (Object)"]", (Object)"[", (Object)"^", (Object)"{", (Object)"}", (Object)"(", (Object[])new String[]{")"});
    private final String indexField;
    private final JqlOperandResolver operandResolver;
    private final TextQueryValidator textQueryValidator;

    public FreeTextFieldValidator(String indexField, JqlOperandResolver operandResolver) {
        this.indexField = Assertions.notBlank("indexField", indexField);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.textQueryValidator = new TextQueryValidator();
    }

    @Override
    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        I18nHelper i18n = this.getI18n(searcher);
        Operator operator = terminalClause.getOperator();
        String fieldName = terminalClause.getName();
        if (!this.handlesOperator(operator)) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.does.not.support.operator", operator.getDisplayString(), fieldName));
            return messageSet;
        }
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> values = this.operandResolver.getValues(searcher, operand, terminalClause);
        if (values != null) {
            for (QueryLiteral literal : values) {
                if (literal.isEmpty()) continue;
                String query = literal.asString();
                if (StringUtils.isNotBlank((String)query)) {
                    String functionName = this.operandResolver.isFunctionOperand(literal.getSourceOperand()) ? literal.getSourceOperand().getName() : null;
                    MessageSet validationResult = this.textQueryValidator.validate(this.getQueryParser(this.indexField), query, fieldName, functionName, false, i18n);
                    messageSet.addMessageSet(validationResult);
                    continue;
                }
                messageSet.addErrorMessage(i18n.getText("jira.jql.text.clause.does.not.support.empty", fieldName));
            }
        } else {
            log.error("Text field validation was provided an operand handler that gave us back more than one value when validating '" + fieldName + "'.");
        }
        return messageSet;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.TEXT_OPERATORS.contains((Object)operator);
    }

    I18nHelper getI18n(ApplicationUser user) {
        I18nHelper.BeanFactory beanFactory = ComponentAccessor.getComponent(I18nHelper.BeanFactory.class);
        return beanFactory.getInstance(user);
    }

    QueryParser getQueryParser(String indexField) {
        return ComponentAccessor.getComponent(LuceneQueryParserFactory.class).createParserFor(indexField);
    }
}

