/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;

public class RangeQueryFactory<T> {
    private final Function<T, String> valueFactory;

    static RangeQueryFactory<String> stringRangeQueryFactory() {
        return new RangeQueryFactory<String>(Functions.identity());
    }

    public RangeQueryFactory(Function<T, String> valueFactory) {
        this.valueFactory = Assertions.notNull("valueFactory", valueFactory);
    }

    Query get(Operator operator, String fieldName, T value) {
        switch (operator) {
            case LESS_THAN: {
                return this.handleLessThan(fieldName, value);
            }
            case LESS_THAN_EQUALS: {
                return this.handleLessThanEquals(fieldName, value);
            }
            case GREATER_THAN: {
                return this.handleGreaterThan(fieldName, value);
            }
            case GREATER_THAN_EQUALS: {
                return this.handleGreaterThanEquals(fieldName, value);
            }
        }
        throw new IllegalArgumentException("Unhandled Operator: " + (Object)((Object)operator));
    }

    Query get(Operator operator, String fieldName, List<T> values) {
        if (operator == Operator.DURING) {
            if (values.get(0) == null) {
                return this.handleLessThanEquals(fieldName, values.get(1));
            }
            if (values.get(1) == null) {
                return this.handleGreaterThanEquals(fieldName, values.get(0));
            }
            return this.handleDuring(fieldName, values.get(0), values.get(1));
        }
        throw new IllegalArgumentException("Unhandled Operator: " + (Object)((Object)operator));
    }

    Query handleLessThan(String fieldName, T value) {
        return new TermRangeQuery(fieldName, null, this.valueFactory.get(value), true, false);
    }

    Query handleLessThanEquals(String fieldName, T value) {
        return new TermRangeQuery(fieldName, null, this.valueFactory.get(value), true, true);
    }

    Query handleGreaterThan(String fieldName, T value) {
        return new TermRangeQuery(fieldName, this.valueFactory.get(value), null, false, true);
    }

    Query handleGreaterThanEquals(String fieldName, T value) {
        return new TermRangeQuery(fieldName, this.valueFactory.get(value), null, true, true);
    }

    Query handleDuring(String fieldName, T lowerValue, T upperValue) {
        return new TermRangeQuery(fieldName, this.valueFactory.get(lowerValue), this.valueFactory.get(upperValue), true, true);
    }
}

