/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.PublicApi;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.user.ApplicationUserBuilder;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserCreationTemplate;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface UserService {
    @Nonnull
    public ApplicationUserBuilder newUserBuilder(@Nonnull ApplicationUser var1);

    public CreateUserValidationResult validateCreateUserForSignup(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForSetup(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForSignupOrSetup(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdmin(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdmin(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6, @Nullable Long var7);

    public CreateUserValidationResult validateCreateUserRequestForAdmin(@Nonnull ApplicationUser var1, @Nonnull ApplicationUserCreationTemplate var2);

    public CreateUsernameValidationResult validateCreateUsername(ApplicationUser var1, String var2);

    public CreateUsernameValidationResult validateCreateUsername(ApplicationUser var1, String var2, Long var3);

    public ApplicationUser createUserFromSignup(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public ApplicationUser createUserWithNotification(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public ApplicationUser createUserNoNotification(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public UpdateUserValidationResult validateUpdateUser(ApplicationUser var1);

    public void updateUser(UpdateUserValidationResult var1);

    public DeleteUserValidationResult validateDeleteUser(ApplicationUser var1, String var2);

    public DeleteUserValidationResult validateDeleteUser(ApplicationUser var1, ApplicationUser var2);

    public void removeUser(ApplicationUser var1, DeleteUserValidationResult var2);

    public AddUserToApplicationValidationResult validateAddUserToApplication(ApplicationUser var1, ApplicationKey var2);

    public void addUserToApplication(AddUserToApplicationValidationResult var1) throws AddException, PermissionException;

    public RemoveUserFromApplicationValidationResult validateRemoveUserFromApplication(ApplicationUser var1, ApplicationKey var2);

    public void removeUserFromApplication(RemoveUserFromApplicationValidationResult var1) throws RemoveException, PermissionException;

    @PublicApi
    public static final class FieldName {
        static String EMAIL = "email";
        static String NAME = "username";
        static String FULLNAME = "fullname";
        static String PASSWORD = "password";
        static String CONFIRM_PASSWORD = "confirm";

        private FieldName() {
        }
    }

    @PublicApi
    public static final class RemoveUserFromApplicationValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser userToRemove;
        private final Set<String> applicationGroupNames;

        RemoveUserFromApplicationValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.userToRemove = null;
            this.applicationGroupNames = null;
        }

        RemoveUserFromApplicationValidationResult(ApplicationUser userToRemove, Set<String> applicationGroupNames) {
            super(new SimpleErrorCollection());
            this.userToRemove = userToRemove;
            this.applicationGroupNames = applicationGroupNames;
        }

        public ApplicationUser getUserToRemove() {
            return this.userToRemove;
        }

        public Set<String> getApplicationGroupNames() {
            return this.applicationGroupNames;
        }
    }

    @PublicApi
    public static final class AddUserToApplicationValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser userToAdd;
        private final Set<Group> applicationDefaultGroups;

        AddUserToApplicationValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.userToAdd = null;
            this.applicationDefaultGroups = null;
        }

        AddUserToApplicationValidationResult(ApplicationUser userToAdd, Set<Group> applicationDefaultGroups) {
            super(new SimpleErrorCollection());
            this.userToAdd = userToAdd;
            this.applicationDefaultGroups = applicationDefaultGroups;
        }

        public ApplicationUser getUserToAdd() {
            return this.userToAdd;
        }

        public Set<Group> getApplicationDefaultGroups() {
            return this.applicationDefaultGroups;
        }
    }

    @PublicApi
    public static final class DeleteUserValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser user;

        DeleteUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
        }

        DeleteUserValidationResult(ApplicationUser user) {
            super(new SimpleErrorCollection());
            this.user = user;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public ApplicationUser getApplicationUser() {
            return this.user;
        }
    }

    @PublicApi
    public static final class UpdateUserValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser user;

        UpdateUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
        }

        UpdateUserValidationResult(ApplicationUser user) {
            super(new SimpleErrorCollection());
            this.user = user;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public ApplicationUser getApplicationUser() {
            return this.user;
        }
    }

    @PublicApi
    public static final class CreateUsernameValidationResult
    extends ServiceResultImpl {
        private final String username;
        private final Long directoryId;

        public CreateUsernameValidationResult(String username, Long directoryId, ErrorCollection errorCollection) {
            super(errorCollection);
            this.username = username;
            this.directoryId = directoryId;
        }

        public String getUsername() {
            return this.username;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }
    }

    @PublicApi
    public static final class CreateUserValidationResult
    extends ServiceResultImpl {
        private final String username;
        private final String password;
        private final String email;
        private final String fullname;
        private final Long directoryId;
        private final List<WebErrorMessage> passwordErrors;
        private final Set<ApplicationKey> applicationKeys;

        CreateUserValidationResult(ErrorCollection errorCollection) {
            this(errorCollection, (List<WebErrorMessage>)ImmutableList.of());
        }

        CreateUserValidationResult(ErrorCollection errorCollection, List<WebErrorMessage> passwordErrors) {
            super(errorCollection);
            this.username = null;
            this.password = null;
            this.email = null;
            this.fullname = null;
            this.directoryId = null;
            this.passwordErrors = ImmutableList.copyOf(passwordErrors);
            this.applicationKeys = null;
        }

        CreateUserValidationResult(String username, String password, String email, String fullname) {
            this(username, password, email, fullname, null);
        }

        CreateUserValidationResult(String username, String password, String email, String fullname, Long directoryId) {
            this(username, password, email, fullname, directoryId, null);
        }

        CreateUserValidationResult(String username, String password, String email, String fullname, Long directoryId, Set<ApplicationKey> applicationKeys) {
            super(new SimpleErrorCollection());
            this.username = username;
            this.password = password;
            this.email = email;
            this.fullname = fullname;
            this.directoryId = directoryId;
            this.passwordErrors = ImmutableList.of();
            this.applicationKeys = applicationKeys;
        }

        CreateUserValidationResult(ApplicationUserCreationTemplate userData) {
            this(userData.getUsername(), userData.getPassword(), userData.getEmailAddress(), userData.getDisplayName(), userData.getDirectoryId().orElse(null), userData.getApplicationKeys());
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getEmail() {
            return this.email;
        }

        public String getFullname() {
            return this.fullname;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }

        public List<WebErrorMessage> getPasswordErrors() {
            return this.passwordErrors;
        }

        public Set<ApplicationKey> getApplicationKeys() {
            if (this.applicationKeys == null) {
                return ImmutableSet.of();
            }
            return this.applicationKeys;
        }

        public ApplicationUserCreationTemplate toApplicationUserCreationData() {
            return new ApplicationUserCreationTemplate(this.getUsername(), this.getFullname()).withDirectory(this.getDirectoryId()).withApplications(this.getApplicationKeys()).withEmail(this.getEmail()).withPassword(this.getPassword());
        }
    }
}

