/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.concurrent.Callable;

@PublicSpi
public abstract class AbstractWebCondition
implements Condition {
    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        final JiraHelper jiraHelper = (JiraHelper)context.get("helper");
        final ApplicationUser appUser = this.getApplicationUser(context);
        return (Boolean)SafePluginPointAccess.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return AbstractWebCondition.this.shouldDisplay(appUser, jiraHelper);
            }
        }).getOrElse((Object)false);
    }

    private ApplicationUser getApplicationUser(Map<String, Object> context) {
        ApplicationUser appUser = ApplicationUsers.from((User)context.get("user"));
        if (appUser == null) {
            String username = (String)context.get("username");
            appUser = this.getUserUtil().getUserByName(username);
        }
        return appUser;
    }

    UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }

    public abstract boolean shouldDisplay(ApplicationUser var1, JiraHelper var2);
}

