/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

abstract class IndexValuesValidator
implements ClauseValidator {
    private final JqlOperandResolver jqlOperandResolver;
    private final IndexValueConverter indexValueConverter;
    private final boolean emptyValuesSupported;

    IndexValuesValidator(JqlOperandResolver jqlOperandResolver, IndexValueConverter indexValueConverter) {
        this(jqlOperandResolver, indexValueConverter, true);
    }

    IndexValuesValidator(JqlOperandResolver jqlOperandResolver, IndexValueConverter indexValueConverter, boolean emptyValuesSupported) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.indexValueConverter = indexValueConverter;
        this.emptyValuesSupported = emptyValuesSupported;
    }

    abstract void addError(MessageSet var1, User var2, TerminalClause var3, QueryLiteral var4);

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messageSet = new MessageSetImpl();
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, operand, terminalClause);
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (!literal.isEmpty() && this.indexValueConverter.convertToIndexValue(literal) == null) {
                    this.addError(messageSet, searcher, terminalClause, literal);
                    continue;
                }
                if (!literal.isEmpty() || this.emptyValuesSupported) continue;
                this.addError(messageSet, searcher, terminalClause, literal);
            }
        }
        return messageSet;
    }
}

