/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public abstract class AbstractEqualityQueryFactory<T>
extends AbstractOperatorQueryFactory<T>
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(AbstractEqualityQueryFactory.class);

    public AbstractEqualityQueryFactory(IndexInfoResolver<T> indexInfoResolver) {
        super(indexInfoResolver);
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.EQUALS.equals((Object)operator)) {
            return this.handleEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_EQUALS.equals((Object)operator)) {
            return this.handleNotEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create query for single value was called with operator '" + operator.getDisplayString() + "', this only handles '=' and '!='."));
        }
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.IN.equals((Object)operator)) {
            return this.handleEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_IN.equals((Object)operator)) {
            return this.handleNotEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create query for multiple value was called with operator '" + operator.getDisplayString() + "', this only handles 'in'."));
        }
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    QueryFactoryResult handleNotEquals(String fieldName, List<String> indexValues) {
        ArrayList notQueries;
        ArrayList arrayList = notQueries = indexValues != null ? Lists.newArrayListWithCapacity((int)indexValues.size()) : Lists.newArrayList();
        if (indexValues != null) {
            for (String indexValue : indexValues) {
                if (indexValue == null) continue;
                notQueries.add(this.getTermQuery(fieldName, indexValue));
            }
        }
        if (notQueries.isEmpty()) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        BooleanQuery boolQuery = new BooleanQuery();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanClause.Occur.MUST);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.MUST);
        return new QueryFactoryResult((Query)boolQuery, false);
    }

    QueryFactoryResult handleEquals(String fieldName, List<String> indexValues) {
        if (indexValues == null) {
            return QueryFactoryResult.createFalseResult();
        }
        if (indexValues.size() == 1) {
            String id = indexValues.get(0);
            return id == null ? new QueryFactoryResult(this.getIsEmptyQuery(fieldName)) : new QueryFactoryResult((Query)this.getTermQuery(fieldName, id));
        }
        BooleanQuery orQuery = new BooleanQuery();
        for (String id : indexValues) {
            if (id != null) {
                orQuery.add((Query)this.getTermQuery(fieldName, id), BooleanClause.Occur.SHOULD);
                continue;
            }
            orQuery.add(this.getIsEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)orQuery);
    }

    abstract Query getIsEmptyQuery(String var1);

    abstract Query getIsNotEmptyQuery(String var1);
}

