/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.ValidatingDecoratorContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

@Internal
public class MultiClauseDecoratorContextFactory
implements ClauseContextFactory {
    private final ClauseContextFactory delegate;
    private final JqlOperandResolver jqlOperandResolver;
    private final ContextSetUtil contextSetUtil;

    public MultiClauseDecoratorContextFactory(JqlOperandResolver jqlOperandResolver, ClauseContextFactory delegate) {
        this(jqlOperandResolver, delegate, ContextSetUtil.getInstance());
    }

    public MultiClauseDecoratorContextFactory(JqlOperandResolver jqlOperandResolver, ClauseContextFactory delegate, ContextSetUtil contextSetUtil) {
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.delegate = Assertions.notNull("delegate", delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        UtilTimerStack.push((String)"MultiClauseDecoratorContextFactory.getClauseContext()");
        try {
            Operand operand = terminalClause.getOperand();
            List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, operand, terminalClause);
            if (literals == null || literals.isEmpty()) {
                ClauseContext clauseContext = ClauseContextImpl.createGlobalClauseContext();
                return clauseContext;
            }
            Operator convertedOperator = MultiClauseDecoratorContextFactory.convertListOperator(terminalClause.getOperator());
            if (convertedOperator == null || !this.jqlOperandResolver.isListOperand(operand)) {
                ClauseContext clauseContext = this.delegate.getClauseContext(searcher, terminalClause);
                return clauseContext;
            }
            UtilTimerStack.push((String)"MultiClauseDecoratorContextFactory.getClauseContext() - looping");
            HashSet<ClauseContext> ctxs = new HashSet<ClauseContext>();
            MultiValueOperand operands = new MultiValueOperand(literals.toArray(new QueryLiteral[literals.size()]));
            TerminalClauseImpl listClause = new TerminalClauseImpl(terminalClause.getName(), convertedOperator, operands);
            UtilTimerStack.pop((String)"MultiClauseDecoratorContextFactory.getClauseContext() - looping");
            UtilTimerStack.push((String)"MultiClauseDecoratorContextFactory.getClauseContext() - delegate");
            ctxs.add(this.delegate.getClauseContext(searcher, listClause));
            UtilTimerStack.pop((String)"MultiClauseDecoratorContextFactory.getClauseContext() - delegate");
            if (convertedOperator == Operator.EQUALS) {
                ClauseContext clauseContext = this.contextSetUtil.union(ctxs);
                return clauseContext;
            }
            ClauseContext clauseContext = this.contextSetUtil.intersect(ctxs);
            return clauseContext;
        }
        finally {
            UtilTimerStack.pop((String)"MultiClauseDecoratorContextFactory.getClauseContext()");
        }
    }

    private static Operator convertListOperator(Operator operator) {
        if (operator == Operator.IN) {
            return Operator.EQUALS;
        }
        if (operator == Operator.NOT_IN) {
            return Operator.NOT_EQUALS;
        }
        return null;
    }

    public static class Factory {
        private final OperatorUsageValidator validator;
        private final JqlOperandResolver resolver;
        private final ContextSetUtil contextSetUtil;

        public Factory(OperatorUsageValidator validator, JqlOperandResolver resolver, ContextSetUtil contextSetUtil) {
            this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
            this.validator = Assertions.notNull("validator", validator);
            this.resolver = Assertions.notNull("resolver", resolver);
        }

        @Nonnull
        public ClauseContextFactory create(@Nonnull ClauseContextFactory delegate) {
            return this.create(delegate, true);
        }

        @Nonnull
        public ClauseContextFactory create(@Nonnull ClauseContextFactory delegate, boolean validating) {
            ClauseContextFactory factory = new MultiClauseDecoratorContextFactory(this.resolver, Assertions.notNull("delegate", delegate), this.contextSetUtil);
            if (validating) {
                factory = new ValidatingDecoratorContextFactory(this.validator, factory);
            }
            return factory;
        }
    }
}

