/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractSingleValueCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.TextQueryValidator;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import com.atlassian.query.operator.Operator;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.QueryParser;

public class FreeTextCustomFieldSearchInputTransformer
extends AbstractSingleValueCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private static final Logger log = Logger.getLogger(FreeTextCustomFieldSearchInputTransformer.class);
    private final CustomField customField;
    private final ClauseNames clauseNames;
    private final TextQueryValidator textQueryValidator;

    public FreeTextCustomFieldSearchInputTransformer(CustomField customField, ClauseNames clauseNames, String urlParameterName, CustomFieldInputHelper customFieldInputHelper) {
        super(customField, clauseNames, urlParameterName, customFieldInputHelper);
        this.customField = customField;
        this.clauseNames = clauseNames;
        this.textQueryValidator = new TextQueryValidator();
    }

    @Override
    Clause createSearchClause(User user, String value) {
        return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.LIKE, value);
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        return this.convertForNavigator(query).fitsNavigator();
    }

    @Override
    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        if (fieldValuesHolder.containsKey(this.customField.getId())) {
            CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.customField.getId());
            String paramValue = this.getFieldValueAsString(this.customField.getCustomFieldType(), customFieldParams, errors);
            if (paramValue != null) {
                MessageSet validationResult = this.textQueryValidator.validate(this.getQueryParser(this.customField), paramValue, this.customField.getFieldName(), null, true, i18nHelper);
                for (String errorMessage : validationResult.getErrorMessages()) {
                    errors.addError(this.customField.getId(), errorMessage);
                }
            }
        }
    }

    private String getFieldValueAsString(CustomFieldType customFieldType, CustomFieldParams customFieldParams, ErrorCollection errors) {
        String paramValue = null;
        Object paramValueObject = new Object();
        try {
            paramValueObject = customFieldType.getValueFromCustomFieldParams(customFieldParams);
            paramValue = (String)paramValueObject;
        }
        catch (FieldValidationException e) {
            errors.addError(this.getCustomField().getId(), e.getMessage());
        }
        catch (ClassCastException e) {
            errors.addError(this.getCustomField().getId(), "Internal error attempting to validate the search term.");
            log.error((Object)("Expected to be able to get String value out of custom customField that has a text searcher, actual value type is " + paramValueObject.getClass()));
        }
        return paramValue;
    }

    QueryParser getQueryParser(CustomField customField) {
        return ComponentAccessor.getComponent(LuceneQueryParserFactory.class).createParserFor(customField.getId());
    }
}

