/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraUrlCodec {
    private static final Logger log = LoggerFactory.getLogger(JiraUrlCodec.class);

    @HtmlSafe
    public static String encode(String value, String encoding, boolean spacesEncodedasHexValue) {
        try {
            return URLCodec.encode(value, encoding, spacesEncodedasHexValue);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Unable to encode '" + value + "' with encoding '" + encoding + "'. Encoding with system defaults.");
            return JiraUrlCodec.systemDefaultEncoding(value, spacesEncodedasHexValue);
        }
    }

    @HtmlSafe
    public static String encode(String value, String encoding) {
        return JiraUrlCodec.encode(value, encoding, false);
    }

    @HtmlSafe
    public static String encode(String value) {
        return JiraUrlCodec.encode(value, false);
    }

    @HtmlSafe
    public static String encode(String value, boolean spacesEncodedasHexValue) {
        return JiraUrlCodec.encode(value, ComponentAccessor.getApplicationProperties().getEncoding(), spacesEncodedasHexValue);
    }

    public static String decode(String value, String encoding) {
        try {
            return URLCodec.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Unable to dencode '" + value + "' with encoding '" + encoding + "'. Encoding with system defaults.");
            return URLDecoder.decode(value);
        }
    }

    public static String decode(String value) {
        return JiraUrlCodec.decode(value, ComponentAccessor.getApplicationProperties().getEncoding());
    }

    static String systemDefaultEncoding(String value, boolean spacesAsHexValue) {
        String encodedResult = URLEncoder.encode(value);
        if (spacesAsHexValue) {
            encodedResult = encodedResult.replaceAll("\\+", "%20");
        }
        return encodedResult;
    }
}

