/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import javax.annotation.Nullable;

@ExperimentalApi
public class AuditingFilter {
    private final String filter;
    private final Long fromTimestamp;
    private final Long toTimestamp;
    private final boolean hideExternalDirectories;

    public static Builder builder() {
        return new Builder();
    }

    private AuditingFilter(@Nullable String filter, @Nullable Long fromTimestamp, @Nullable Long toTimestamp, boolean hideExternalDirectories) {
        this.filter = filter;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.hideExternalDirectories = hideExternalDirectories;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nullable
    public Long getFromTimestamp() {
        return this.fromTimestamp;
    }

    @Nullable
    public Long getToTimestamp() {
        return this.toTimestamp;
    }

    public boolean isHideExternalDirectories() {
        return this.hideExternalDirectories;
    }

    public static class Builder {
        private String filter;
        private Long fromTimestamp;
        private Long toTimestamp;
        private boolean hideExternalDirectories = false;

        private Builder() {
        }

        public Builder filter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public Builder fromTimestamp(@Nullable Long fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public Builder toTimestamp(@Nullable Long toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        public Builder setHideExternalDirectories(boolean hideExternalDirectories) {
            this.hideExternalDirectories = hideExternalDirectories;
            return this;
        }

        public AuditingFilter build() {
            return new AuditingFilter(this.filter, this.fromTimestamp, this.toTimestamp, this.hideExternalDirectories);
        }
    }
}

