/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.profile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DarkFeatures {
    private final Set<String> systemEnabledFeatures;
    private final Set<String> siteEnabledFeatures;
    private final Set<String> userEnabledFeatures;

    public DarkFeatures(Set<String> systemEnabledFeatures, Set<String> siteEnabledFeatures, Set<String> userEnabledFeatures) {
        this.systemEnabledFeatures = ImmutableSet.copyOf(systemEnabledFeatures);
        this.userEnabledFeatures = ImmutableSet.copyOf(userEnabledFeatures);
        this.siteEnabledFeatures = ImmutableSet.copyOf(siteEnabledFeatures);
    }

    public Set<String> getSystemEnabledFeatures() {
        return this.systemEnabledFeatures;
    }

    public Set<String> getSiteEnabledFeatures() {
        return this.siteEnabledFeatures;
    }

    public Set<String> getUserEnabledFeatures() {
        return this.userEnabledFeatures;
    }

    public Set<String> getGlobalEnabledFeatureKeys() {
        return Sets.union(this.systemEnabledFeatures, this.siteEnabledFeatures);
    }

    public Set<String> getAllEnabledFeatures() {
        return Sets.union((Set)Sets.union(this.userEnabledFeatures, this.siteEnabledFeatures), this.systemEnabledFeatures);
    }

    public boolean isFeatureEnabled(String featureKey) {
        return this.getAllEnabledFeatures().contains(StringUtils.trim((String)featureKey));
    }
}

