/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

class VersionValuesExistValidator
extends ValuesExistValidator {
    private final VersionIndexInfoResolver versionIndexInfoResolver;
    private final PermissionManager permissionManager;
    private final VersionManager versionManager;

    VersionValuesExistValidator(JqlOperandResolver operandResolver, VersionIndexInfoResolver versionIndexInfoResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        super(operandResolver, beanFactory);
        this.versionIndexInfoResolver = Assertions.notNull("versionIndexInfoResolver", versionIndexInfoResolver);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.versionManager = Assertions.notNull("versionManager", versionManager);
    }

    @Override
    boolean stringValueExists(User searcher, String value) {
        List<String> ids = this.versionIndexInfoResolver.getIndexedValues(value);
        return this.versionExists(searcher, ids);
    }

    @Override
    boolean longValueExist(User searcher, Long value) {
        List<String> ids = this.versionIndexInfoResolver.getIndexedValues(value);
        return this.versionExists(searcher, ids);
    }

    boolean versionExists(User searcher, List<String> ids) {
        for (String sid : ids) {
            Version version;
            Long id = this.convertToLong(sid);
            if (id == null || (version = this.versionManager.getVersion(id)) == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, version.getProjectObject(), ApplicationUsers.from(searcher))) continue;
            return true;
        }
        return false;
    }

    private Long convertToLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

