/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ListOrderedMessageSetImpl;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

abstract class ValuesExistValidator {
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory beanFactory;
    private final MessageSet.Level level;

    ValuesExistValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this(operandResolver, beanFactory, MessageSet.Level.ERROR);
    }

    ValuesExistValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory, MessageSet.Level level) {
        this.beanFactory = Assertions.notNull("beanFactory", beanFactory);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.level = level;
    }

    MessageSet validate(TerminalClause terminalClause, QueryCreationContext queryCreationContext) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> rawOperandValues = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        return this.validate(ApplicationUsers.toDirectoryUser(queryCreationContext.getApplicationUser()), terminalClause, rawOperandValues);
    }

    MessageSet validate(User searcher, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> rawOperandValues = this.operandResolver.getValues(searcher, operand, terminalClause);
        return this.validate(searcher, terminalClause, rawOperandValues);
    }

    private MessageSet validate(User searcher, TerminalClause terminalClause, List<QueryLiteral> rawOperandValues) {
        Operand operand = terminalClause.getOperand();
        String fieldName = terminalClause.getName();
        ListOrderedMessageSetImpl messages = new ListOrderedMessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            for (QueryLiteral rawValue : rawOperandValues) {
                if (rawValue.getStringValue() != null) {
                    if (this.stringValueExists(searcher, rawValue.getStringValue())) continue;
                    if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                        messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                        continue;
                    }
                    messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", fieldName, rawValue.getStringValue()));
                    continue;
                }
                if (rawValue.getLongValue() == null || this.longValueExist(searcher, rawValue.getLongValue())) continue;
                if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                    messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                    continue;
                }
                messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.id", fieldName, rawValue.getLongValue().toString()));
            }
        }
        return messages;
    }

    abstract boolean stringValueExists(User var1, String var2);

    abstract boolean longValueExist(User var1, Long var2);

    I18nHelper getI18n(User user) {
        return this.beanFactory.getInstance(user);
    }
}

