/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.List;

@PublicApi
public class Pages {
    public static <T> Page<T> toPage(Iterable<T> allValues, PageRequest pageRequest) {
        Iterable tail = Iterables.skip(allValues, (int)Ints.checkedCast((long)pageRequest.getStart()));
        Iterable lastPagePlusOne = Iterables.limit((Iterable)tail, (int)(pageRequest.getLimit() + 1));
        boolean hasNext = Iterables.size((Iterable)lastPagePlusOne) == pageRequest.getLimit() + 1;
        Iterable valuesForPage = Iterables.limit((Iterable)lastPagePlusOne, (int)pageRequest.getLimit());
        return PageImpl.builder().addValues(valuesForPage).setSize(Iterables.size((Iterable)valuesForPage)).setStart(pageRequest.getStart()).setTotal(Long.valueOf(Iterables.size(allValues))).setIsLast(!hasNext).build();
    }

    private static final class PageImpl<T>
    implements Page<T> {
        private final long start;
        private final Long total;
        private final int size;
        private final boolean isLast;
        private final List<T> values;

        private PageImpl(long start, Long total, int size, boolean isLast, Iterable<T> values) {
            this.start = start;
            this.total = (Long)Preconditions.checkNotNull((Object)total);
            this.size = size;
            this.isLast = isLast;
            this.values = ImmutableList.copyOf(values);
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public Long getTotal() {
            return this.total;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean isLast() {
            return this.isLast;
        }

        @Override
        public List<T> getValues() {
            return this.values;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static <T> Builder<T> builder(PageImpl<T> data) {
            return new Builder(data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageImpl that = (PageImpl)o;
            return Objects.equal((Object)this.start, (Object)that.start) && Objects.equal((Object)this.total, (Object)that.total) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.isLast, (Object)that.isLast) && Objects.equal(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.start, this.total, this.size, this.isLast, this.values});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("start", this.start).add("total", (Object)this.total).add("size", this.size).add("hasNext", this.isLast).add("values", this.values).toString();
        }

        public static final class Builder<T> {
            private long start;
            private Long total;
            private int size;
            private boolean isLast;
            private List<T> values = Lists.newArrayList();

            private Builder() {
            }

            private Builder(PageImpl<T> initialData) {
                this.start = ((PageImpl)initialData).start;
                this.total = ((PageImpl)initialData).total;
                this.size = ((PageImpl)initialData).size;
                this.isLast = ((PageImpl)initialData).isLast;
                this.values = ((PageImpl)initialData).values;
            }

            public Builder<T> setStart(long start) {
                this.start = start;
                return this;
            }

            public Builder<T> setTotal(Long total) {
                this.total = total;
                return this;
            }

            public Builder<T> setSize(int size) {
                this.size = size;
                return this;
            }

            public Builder<T> setIsLast(boolean isLast) {
                this.isLast = isLast;
                return this;
            }

            public Builder<T> setValues(List<T> values) {
                this.values = values;
                return this;
            }

            public Builder<T> addValue(T value) {
                this.values.add(value);
                return this;
            }

            public Builder<T> addValues(Iterable<T> values) {
                for (T value : values) {
                    this.addValue(value);
                }
                return this;
            }

            public PageImpl<T> build() {
                return new PageImpl(this.start, this.total, this.size, this.isLast, this.values);
            }
        }
    }
}

