/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.config.item;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.GenericImmutableOptions;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class VersionOptionsConfigItem
implements FieldConfigItemType {
    private static final Logger log = LoggerFactory.getLogger(VersionOptionsConfigItem.class);
    private final VersionManager versionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Deprecated
    public VersionOptionsConfigItem(VersionManager versionManager) {
        this.versionManager = versionManager;
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    }

    public VersionOptionsConfigItem(VersionManager versionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.versionManager = versionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return "Version options";
    }

    @Override
    public String getDisplayNameKey() {
        return "admin.issuefields.customfields.config.version.options";
    }

    @Override
    public String getViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.issuefields.customfields.config.version.options.all");
    }

    @Override
    public String getObjectKey() {
        return "options";
    }

    @Override
    public Object getConfigurationObject(Issue issue, FieldConfig config) {
        if (issue != null && issue.getProjectId() != null) {
            return new GenericImmutableOptions<Version>(this.versionManager.getVersions(issue.getProjectId()), config);
        }
        return new GenericImmutableOptions(Collections.EMPTY_LIST, config);
    }

    @Override
    public String getBaseEditUrl() {
        return null;
    }
}

