/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.language;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import java.util.List;
import java.util.Locale;

@PublicSpi
public class Language {
    private String encoding;
    private Locale locale;
    private String flagUrl;

    public Language(Locale locale) {
        this.locale = locale;
    }

    public Language(LanguageModuleDescriptor moduleDescriptor) {
        this.setEncoding(moduleDescriptor.getEncoding());
        String language = moduleDescriptor.getLanguage();
        String country = moduleDescriptor.getCountry();
        String variant = moduleDescriptor.getVariant();
        if (language == null) {
            throw new NullPointerException("The language attribute of Language cannot be null");
        }
        if (country == null) {
            country = "";
        }
        if (variant == null) {
            variant = "";
        }
        this.locale = new Locale(language, country, variant);
        List resources = moduleDescriptor.getResourceDescriptors("download");
        if (resources.size() > 0) {
            ResourceDescriptor descriptor = (ResourceDescriptor)resources.get(0);
            this.setFlagUrl("/download/resources/" + moduleDescriptor.getCompleteKey() + "/" + descriptor.getName());
        }
    }

    public String getName() {
        return this.getLocale().toString();
    }

    public String getDisplayLanguage() {
        return this.getLocale().getDisplayLanguage(this.getLocale());
    }

    public String getDisplayName() {
        return this.getLocale().getDisplayName(this.getLocale());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLanguage(String language) {
        Locale oldLocale = this.getLocale();
        Locale newLocale = new Locale(language, oldLocale.getCountry(), oldLocale.getVariant());
        this.setLocale(newLocale);
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public void setCountry(String country) {
        Locale oldLocale = this.getLocale();
        Locale newLocale = new Locale(oldLocale.getLanguage(), country, oldLocale.getVariant());
        this.setLocale(newLocale);
    }

    public String getCountry() {
        return this.locale.getCountry();
    }

    public void setVariant(String variant) {
        Locale oldLocale = this.getLocale();
        Locale newLocale = new Locale(oldLocale.getLanguage(), oldLocale.getCountry(), variant);
        this.setLocale(newLocale);
    }

    public String setVariant() {
        return this.locale.getVariant();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getFlagUrl() {
        return this.flagUrl;
    }

    public void setFlagUrl(String flagUrl) {
        this.flagUrl = flagUrl;
    }
}

