/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.jql.validator.VersionValuesExistValidator;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.annotations.VisibleForTesting;

abstract class AbstractVersionValidator
implements ClauseValidator {
    private final ValuesExistValidator versionValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator = this.getSupportedOperatorsValidator();

    AbstractVersionValidator(VersionResolver versionResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        this.versionValuesExistValidator = this.getVersionValuesExistValidator(versionResolver, operandResolver, permissionManager, versionManager, beanFactory);
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        return this.versionValuesExistValidator.validate(searcher, terminalClause);
    }

    public MessageSet validate(TerminalClause terminalClause, QueryCreationContext queryCreationContext) {
        MessageSet errors = this.supportedOperatorsValidator.validate(queryCreationContext.getApplicationUser(), terminalClause);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        return this.versionValuesExistValidator.validate(terminalClause, queryCreationContext);
    }

    @VisibleForTesting
    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS);
    }

    @VisibleForTesting
    VersionValuesExistValidator getVersionValuesExistValidator(VersionResolver versionResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, VersionManager versionManager, I18nHelper.BeanFactory beanFactory) {
        return new VersionValuesExistValidator(operandResolver, new VersionIndexInfoResolver(versionResolver), permissionManager, versionManager, beanFactory);
    }
}

