/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public interface JiraWorkflow
extends Comparable<JiraWorkflow> {
    public static final String JIRA_META_ATTRIBUTE_KEY_PREFIX = "jira.";
    public static final String JIRA_META_ATTRIBUTE_PERMISSION = "jira.permission";
    public static final String JIRA_META_ATTRIBUTE_EDIT_ALLOWED = "jira.issue.editable";
    public static final String JIRA_META_ATTRIBUTE_EXCLUDE_RESOLUTION = "jira.field.resolution.exclude";
    public static final String JIRA_META_ATTRIBUTE_INCLUDE_RESOLUTION = "jira.field.resolution.include";
    public static final String JIRA_META_ATTRIBUTE_I18N = "jira.i18n.title";
    public static final String JIRA_META_ATTRIBUTE_I18N_SUBMIT = "jira.i18n.submit";
    public static final String JIRA_META_UPDATE_AUTHOR_NAME = "jira.update.author.name";
    public static final String JIRA_META_UPDATE_AUTHOR_KEY = "jira.update.author.key";
    public static final String JIRA_META_UPDATED_DATE = "jira.updated.date";
    public static final String[] JIRA_META_ATTRIBUTE_ALLOWED_LIST = new String[]{"jira.permission", "jira.issue.editable", "jira.i18n.title", "jira.field.resolution.exclude", "jira.field.resolution.include", "jira.i18n.submit"};
    public static final String STEP_STATUS_KEY = "jira.status.id";
    public static final String WORKFLOW_DESCRIPTION_ATTRIBUTE = "jira.description";
    public static final String WORKFLOW_VIEW_FIELDLAYOUT_KEY_ATTRIBUTE = "jira.view.fieldlayout.key";
    public static final String ACTION_SCREEN_ATTRIBUTE = "jira.fieldscreen.id";
    public static final String DEFAULT_WORKFLOW_NAME = "jira";
    public static final String ACTION_TYPE_INITIAL = "initial";
    public static final String ACTION_TYPE_GLOBAL = "global";
    public static final String ACTION_TYPE_COMMON = "common";
    public static final String ACTION_TYPE_ORDINARY = "ordinary";
    public static final String DRAFT = "draft";
    public static final String LIVE = "live";
    public static final Collection<String> ACTION_TYPE_ALL = CollectionBuilder.list("initial", "global", "common", "ordinary");
    public static final int ACTION_ORIGIN_STEP_ID = -1;

    public String getName();

    public String getDisplayName();

    public String getDescription();

    public WorkflowDescriptor getDescriptor();

    public Collection<ActionDescriptor> getAllActions();

    public Collection<ActionDescriptor> getActionsByName(String var1);

    public Collection<ActionDescriptor> getActionsWithResult(StepDescriptor var1);

    public boolean removeStep(StepDescriptor var1);

    public StepDescriptor getLinkedStep(GenericValue var1);

    public StepDescriptor getLinkedStep(Status var1);

    public List<GenericValue> getLinkedStatuses();

    public List<Status> getLinkedStatusObjects();

    public Set<String> getLinkedStatusIds();

    public boolean isActive() throws WorkflowException;

    public boolean isSystemWorkflow() throws WorkflowException;

    public boolean isEditable() throws WorkflowException;

    public boolean isDefault();

    public boolean isDraftWorkflow();

    public boolean hasDraftWorkflow();

    public int getNextActionId();

    public Collection<StepDescriptor> getStepsForTransition(ActionDescriptor var1);

    public Collection<FunctionDescriptor> getPostFunctionsForTransition(ActionDescriptor var1);

    public boolean isInitialAction(ActionDescriptor var1);

    public boolean isCommonAction(ActionDescriptor var1);

    public boolean isGlobalAction(ActionDescriptor var1);

    public boolean isOrdinaryAction(ActionDescriptor var1);

    public GenericValue getLinkedStatus(StepDescriptor var1);

    public Status getLinkedStatusObject(StepDescriptor var1);

    public String getLinkedStatusId(StepDescriptor var1);

    public String getActionType(ActionDescriptor var1);

    public void reset();

    public Collection<ActionDescriptor> getActionsForScreen(FieldScreen var1);

    public String getUpdateAuthorName();

    public ApplicationUser getUpdateAuthor();

    public Date getUpdatedDate();

    public String getMode();
}

