/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String name;
    @JsonProperty
    private String key;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private Map<String, String> avatarUrls;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private String timeZone;
    public static final UserJsonBean USER_DOC_EXAMPLE = new UserJsonBean();
    public static final UserJsonBean USER_SHORT_DOC_EXAMPLE = new UserJsonBean();

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Deprecated
    public void setEmailAddress(String emailAddress) {
        this.setEmailAddress(emailAddress, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public void setEmailAddress(String emailAddress, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        this.emailAddress = emailFormatter.formatEmail(emailAddress, loggedInUser != null ? loggedInUser.getDirectoryUser() : null);
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public void setAvatarUrls(Map<String, String> avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<User> users, JiraBaseUrls urls) {
        return UserJsonBean.shortBeans(users, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<User> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return UserJsonBean.shortBeans(users, urls, loggedInUser, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<User> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        if (users == null) {
            return null;
        }
        ImmutableList applicationUsers = ImmutableList.copyOf((Iterable)Iterables.transform(users, (Function)new Function<User, ApplicationUser>(){

            public ApplicationUser apply(User user) {
                return ApplicationUsers.from(user);
            }
        }));
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection((Collection<ApplicationUser>)applicationUsers, loggedInUser, urls, emailFormatter, timeZoneManager);
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(users, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), urls, ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(users, loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(users, loggedInUser, urls, emailFormatter, timeZoneManager);
    }

    @Deprecated
    public static UserJsonBean shortBean(User user, JiraBaseUrls urls) {
        ApplicationUser applicationUser = ApplicationUsers.from(user);
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(applicationUser, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), urls, ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static UserJsonBean shortBean(User user, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ApplicationUser applicationUser = ApplicationUsers.from(user);
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(applicationUser, loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static UserJsonBean shortBean(User user, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        ApplicationUser applicationUser = ApplicationUsers.from(user);
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(applicationUser, loggedInUser, urls, emailFormatter, timeZoneManager);
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser user, JiraBaseUrls urls) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(user, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), urls, ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser user, JiraBaseUrls urls, ApplicationUser currentUser, EmailFormatter emailFormatter) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(user, currentUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser user, JiraBaseUrls urls, ApplicationUser currentUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(user, currentUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    static {
        USER_DOC_EXAMPLE.setSelf("http://www.example.com/jira/rest/api/2/user?username=fred");
        USER_DOC_EXAMPLE.setName("fred");
        UserJsonBean.USER_DOC_EXAMPLE.emailAddress = "fred@example.com";
        USER_DOC_EXAMPLE.setDisplayName("Fred F. User");
        USER_DOC_EXAMPLE.setActive(true);
        USER_DOC_EXAMPLE.setAvatarUrls(MapBuilder.newBuilder().add("16x16", "http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred").add("24x24", "http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred").add("32x32", "http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred").add("48x48", "http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred").toMap());
        USER_DOC_EXAMPLE.setTimeZone("Australia/Sydney");
        USER_SHORT_DOC_EXAMPLE.setSelf(USER_DOC_EXAMPLE.getSelf());
        USER_SHORT_DOC_EXAMPLE.setName(USER_DOC_EXAMPLE.getName());
        USER_SHORT_DOC_EXAMPLE.setDisplayName(USER_DOC_EXAMPLE.getDisplayName());
    }
}

