/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.EmailFormatter;
import java.util.ArrayList;
import java.util.List;

public class UserClauseValuesGenerator
implements ClauseValuesGenerator {
    private final UserPickerSearchService userPickerSearchService;
    private final EmailFormatter emailFormatter;

    @Deprecated
    public UserClauseValuesGenerator(UserPickerSearchService userPickerSearchService) {
        this(userPickerSearchService, ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public UserClauseValuesGenerator(UserPickerSearchService userPickerSearchService, EmailFormatter emailFormatter) {
        this.userPickerSearchService = userPickerSearchService;
        this.emailFormatter = emailFormatter;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<ClauseValuesGenerator.Result> userValues = new ArrayList<ClauseValuesGenerator.Result>();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(searcher);
        if (this.userPickerSearchService.canPerformAjaxSearch(serviceContext)) {
            List<User> users = this.userPickerSearchService.findUsersAllowEmptyQuery(serviceContext, valuePrefix);
            for (User user : users) {
                if (userValues.size() == maxNumResults) break;
                ClauseValuesGenerator.Result userValue = new ClauseValuesGenerator.Result(user.getName(), this.assembleDisplayNameParts(user, searcher));
                userValues.add(userValue);
            }
        }
        return new ClauseValuesGenerator.Results(userValues);
    }

    private String[] assembleDisplayNameParts(User user, User searcher) {
        String fullName = user.getDisplayName();
        String name = user.getName();
        String email = this.emailFormatter.formatEmail(user, searcher);
        if (email != null) {
            return new String[]{fullName, "- " + email, " (" + name + ")"};
        }
        return new String[]{fullName, " (" + name + ")"};
    }
}

