/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class WatchersJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private long watchCount;
    @JsonProperty(value="isWatching")
    private boolean watching;
    @JsonProperty
    private Collection<UserJsonBean> watchers;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public long getWatchCount() {
        return this.watchCount;
    }

    public void setWatchCount(long watchCount) {
        this.watchCount = watchCount;
    }

    @JsonIgnore
    public boolean isWatching() {
        return this.watching;
    }

    public void setWatching(boolean watching) {
        this.watching = watching;
    }

    public Collection<UserJsonBean> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(Collection<UserJsonBean> watchers) {
        this.watchers = watchers;
    }

    public static WatchersJsonBean shortBean(String issueKey, long watchers, boolean isWatching, JiraBaseUrls urls) {
        WatchersJsonBean bean = new WatchersJsonBean();
        bean.self = urls.restApi2BaseUrl() + "issue/" + issueKey + "/watchers";
        bean.watching = isWatching;
        bean.watchCount = watchers;
        return bean;
    }

    @Deprecated
    public static WatchersJsonBean fullBean(String issueKey, long watchers, boolean isWatching, Collection<User> watcherrs, JiraBaseUrls urls) {
        return WatchersJsonBean.fullBean(issueKey, watchers, isWatching, watcherrs, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static WatchersJsonBean fullBean(String issueKey, long watchers, boolean isWatching, Collection<User> watcherrs, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        WatchersJsonBean bean = WatchersJsonBean.shortBean(issueKey, watchers, isWatching, urls);
        ArrayList result = Lists.newArrayListWithCapacity((int)watcherrs.size());
        TimeZoneManager timeZoneManager = ComponentAccessor.getComponent(TimeZoneManager.class);
        UserBeanFactory userBeanFactory = ComponentAccessor.getComponent(UserBeanFactory.class);
        for (User from : watcherrs) {
            result.add(userBeanFactory.createBean(from, loggedInUser, urls, emailFormatter, timeZoneManager));
        }
        bean.watchers = result;
        return bean;
    }
}

