/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@PublicApi
public interface QueryContext {
    public Collection<ProjectIssueTypeContexts> getProjectIssueTypeContexts();

    public static class ProjectIssueTypeContexts {
        private final ProjectContext project;
        private final Collection<IssueTypeContext> issueTypes;

        public ProjectIssueTypeContexts(ProjectContext project, Collection<IssueTypeContext> issueTypes) {
            this.project = project;
            this.issueTypes = issueTypes;
        }

        public ProjectContext getProjectContext() {
            return this.project;
        }

        public List<Long> getProjectIdInList() {
            if (this.project.isAll()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.project.getProjectId());
        }

        public List<String> getIssueTypeIds() {
            ArrayList issueTypeIds = Lists.newArrayListWithCapacity((int)this.issueTypes.size());
            for (IssueTypeContext issueType : this.issueTypes) {
                if (issueType.isAll()) continue;
                issueTypeIds.add(issueType.getIssueTypeId());
            }
            return issueTypeIds;
        }

        public Collection<IssueTypeContext> getIssueTypeContexts() {
            return this.issueTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectIssueTypeContexts contexts = (ProjectIssueTypeContexts)o;
            if (this.issueTypes != null ? !((Object)this.issueTypes).equals(contexts.issueTypes) : contexts.issueTypes != null) {
                return false;
            }
            return !(this.project != null ? !this.project.equals(contexts.project) : contexts.project != null);
        }

        public int hashCode() {
            int result = this.project != null ? this.project.hashCode() : 0;
            result = 31 * result + (this.issueTypes != null ? ((Object)this.issueTypes).hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("project", (Object)this.project).append("issueTypes", this.issueTypes).toString();
        }
    }
}

