/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.config.item;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.GenericImmutableOptions;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import java.util.Collections;
import org.apache.log4j.Logger;

public class VersionOptionsConfigItem
implements FieldConfigItemType {
    private static final Logger log = Logger.getLogger(VersionOptionsConfigItem.class);
    private final VersionManager versionManager;

    public VersionOptionsConfigItem(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public String getDisplayName() {
        return "Version options";
    }

    @Override
    public String getDisplayNameKey() {
        return "admin.issuefields.customfields.config.version.options";
    }

    @Override
    public String getViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        return "All versions available for the project of the issue";
    }

    @Override
    public String getObjectKey() {
        return "options";
    }

    @Override
    public Object getConfigurationObject(Issue issue, FieldConfig config) {
        if (issue != null && issue.getProjectId() != null) {
            return new GenericImmutableOptions<Version>(this.versionManager.getVersions(issue.getProjectId()), config);
        }
        return new GenericImmutableOptions(Collections.EMPTY_LIST, config);
    }

    @Override
    public String getBaseEditUrl() {
        return null;
    }
}

