/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestBase;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.index.request.SharedEntityType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class ReindexRequest
extends ReindexRequestBase {
    @Nonnull
    private final Set<AffectedIndex> affectedIndexes;
    @Nonnull
    private final Set<SharedEntityType> sharedEntities;
    @Nonnull
    private final List<ReindexRequest> sources;

    protected ReindexRequest(@Nullable Long id, @Nonnull ReindexRequestType type, @Nullable String query, long requestTime, @Nullable Long startTime, @Nullable Long completionTime, @Nonnull ReindexStatus status, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities, @Nonnull List<ReindexRequest> sources) {
        super(id, type, query, requestTime, startTime, completionTime, status);
        this.affectedIndexes = ImmutableSet.copyOf(affectedIndexes);
        this.sharedEntities = ImmutableSet.copyOf(sharedEntities);
        this.sources = ImmutableList.copyOf(sources);
    }

    public ReindexRequest(@Nullable Long id, @Nonnull ReindexRequestType type, @Nullable String query, long requestTime, @Nullable Long startTime, @Nullable Long completionTime, @Nonnull ReindexStatus status, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities) {
        this(id, type, query, requestTime, startTime, completionTime, status, affectedIndexes, sharedEntities, (List<ReindexRequest>)ImmutableList.of());
    }

    public ReindexRequest(@Nonnull ReindexRequestType type, @Nullable String query, long requestTime, @Nullable Long startTime, @Nullable Long completionTime, @Nonnull ReindexStatus status, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities, @Nonnull List<ReindexRequest> sources) {
        this(null, type, query, requestTime, startTime, completionTime, status, affectedIndexes, sharedEntities, (List<ReindexRequest>)ImmutableList.copyOf(sources));
    }

    public ReindexRequest(@Nonnull ReindexRequestBase base, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> sharedEntities) {
        this(base.getId(), base.getType(), base.getQuery(), base.getRequestTime(), base.getStartTime(), base.getCompletionTime(), base.getStatus(), affectedIndexes, sharedEntities, (List<ReindexRequest>)ImmutableList.of());
    }

    @Nonnull
    public Set<AffectedIndex> getAffectedIndexes() {
        return this.affectedIndexes;
    }

    @Nonnull
    public Set<SharedEntityType> getSharedEntities() {
        return this.sharedEntities;
    }

    @Nonnull
    public List<ReindexRequest> getSources() {
        return this.sources;
    }
}

