/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventListener;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractIssueEventListener
implements IssueEventListener {
    private static final Logger log = Logger.getLogger(AbstractIssueEventListener.class);

    @Override
    public void issueCreated(IssueEvent event) {
    }

    @Override
    public void issueUpdated(IssueEvent event) {
    }

    @Override
    public void issueAssigned(IssueEvent event) {
    }

    @Override
    public void issueResolved(IssueEvent event) {
    }

    @Override
    public void issueClosed(IssueEvent event) {
    }

    @Override
    public void issueCommented(IssueEvent event) {
    }

    public void issueCommentEdited(IssueEvent event) {
    }

    public void issueCommentDeleted(IssueEvent event) {
        this.issueUpdated(event);
    }

    public void issueWorklogUpdated(IssueEvent event) {
    }

    public void issueWorklogDeleted(IssueEvent event) {
    }

    @Override
    public void issueReopened(IssueEvent event) {
    }

    @Override
    public void issueDeleted(IssueEvent event) {
    }

    @Override
    public void issueWorkLogged(IssueEvent event) {
    }

    @Override
    public void issueStarted(IssueEvent event) {
    }

    @Override
    public void issueStopped(IssueEvent event) {
    }

    @Override
    public void issueMoved(IssueEvent event) {
    }

    @Override
    public void issueGenericEvent(IssueEvent event) {
    }

    @Override
    public void workflowEvent(IssueEvent event) {
        Long eventTypeId;
        EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();
        EventType eventType = eventTypeManager.getEventType(eventTypeId = event.getEventTypeId());
        if (eventType == null) {
            log.error((Object)("Issue Event Type with ID '" + eventTypeId + "' is not recognised."));
        } else if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            this.issueCreated(event);
        } else if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            this.issueUpdated(event);
        } else if (eventTypeId.equals(EventType.ISSUE_ASSIGNED_ID)) {
            this.issueAssigned(event);
        } else if (eventTypeId.equals(EventType.ISSUE_RESOLVED_ID)) {
            this.issueResolved(event);
        } else if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID)) {
            this.issueCommented(event);
        } else if (eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
            this.issueCommentEdited(event);
        } else if (eventTypeId.equals(EventType.ISSUE_COMMENT_DELETED_ID)) {
            this.issueCommentDeleted(event);
        } else if (eventTypeId.equals(EventType.ISSUE_CLOSED_ID)) {
            this.issueClosed(event);
        } else if (eventTypeId.equals(EventType.ISSUE_REOPENED_ID)) {
            this.issueReopened(event);
        } else if (eventTypeId.equals(EventType.ISSUE_DELETED_ID)) {
            this.issueDeleted(event);
        } else if (eventTypeId.equals(EventType.ISSUE_MOVED_ID)) {
            this.issueMoved(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKLOGGED_ID)) {
            this.issueWorkLogged(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKSTARTED_ID)) {
            this.issueStarted(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKSTOPPED_ID)) {
            this.issueStopped(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKLOG_UPDATED_ID)) {
            this.issueWorklogUpdated(event);
        } else if (eventTypeId.equals(EventType.ISSUE_WORKLOG_DELETED_ID)) {
            this.issueWorklogDeleted(event);
        } else if (eventTypeId.equals(EventType.ISSUE_GENERICEVENT_ID)) {
            this.issueGenericEvent(event);
        } else {
            this.customEvent(event);
        }
    }

    @Override
    public void customEvent(IssueEvent event) {
    }

    public void init(Map params) {
    }

    @Override
    public String[] getAcceptedParams() {
        return new String[0];
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    protected I18nHelper getI18NBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }
}

