/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.util;

import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class VersionHelperBean {
    public static final Long UNKNOWN_VERSION_ID = new Long(-1L);
    public static final Long UNRELEASED_VERSION_ID = new Long(-2L);
    public static final Long RELEASED_VERSION_ID = new Long(-3L);
    private VersionManager versionManager;
    private final PermissionManager permissionManager;
    public static final String NEW_VERSION_RREFIX = "nv_";

    public VersionHelperBean(VersionManager versionManager) {
        this.versionManager = versionManager;
        this.permissionManager = ComponentAccessor.getPermissionManager();
    }

    public VersionHelperBean(VersionManager versionManager, PermissionManager permissionManager) {
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
    }

    public boolean validateVersionIds(Collection versionIds, ErrorCollection errorCollection, I18nHelper i18n, String fieldId) {
        boolean valid = true;
        if (versionIds != null) {
            if (versionIds.size() > 1 && versionIds.contains(UNKNOWN_VERSION_ID)) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.noneselectedwithother"), ErrorCollection.Reason.VALIDATION_FAILED);
                valid = false;
            }
            for (Object o : versionIds) {
                Long l = this.getVersionIdAsLong(o);
                if (l >= -1L) continue;
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.releasedunreleasedselected"), ErrorCollection.Reason.VALIDATION_FAILED);
                valid = false;
            }
        }
        return valid;
    }

    public void validateVersionForProject(Collection versionIds, Project project, ErrorCollection errorCollection, I18nHelper i18n, String fieldId) {
        if (versionIds != null && project != null) {
            Long projectId = project.getId();
            StringBuilder sb = null;
            for (Object versionId : versionIds) {
                Long id = this.getVersionIdAsLong(versionId);
                if (id == -1L) {
                    return;
                }
                Version version = this.versionManager.getVersion(id);
                if (version == null) {
                    errorCollection.addError(fieldId, i18n.getText("issue.field.versions.invalid.version.id", id), ErrorCollection.Reason.VALIDATION_FAILED);
                    return;
                }
                Long versionProjectId = version.getProjectObject().getId();
                if (versionProjectId.equals(projectId)) continue;
                if (sb == null) {
                    sb = new StringBuilder(version.getName()).append("(").append(version.getId()).append(")");
                    continue;
                }
                sb.append(", ").append(version.getName()).append("(").append(version.getId()).append(")");
            }
            if (sb != null) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.versions.not.valid.for.project", sb.toString(), project.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    public void validateVersionsToCreate(ApplicationUser user, I18nHelper i18n, Project project, String fieldId, Set<String> newVersionNames, ErrorCollection errorCollection) {
        if (this.permissionManager.hasPermission(23, project, user)) {
            VersionService versionService = this.getVersionService();
            for (String version : newVersionNames) {
                if (StringUtils.startsWith((String)version, (String)NEW_VERSION_RREFIX)) {
                    VersionService.VersionBuilder builder = versionService.newBuilder().projectId(project.getId()).name(StringUtils.substring((String)version, (int)NEW_VERSION_RREFIX.length()));
                    VersionService.VersionBuilderValidationResult result = versionService.validateCreate(ApplicationUsers.toDirectoryUser(user), builder);
                    if (result.isValid()) continue;
                    ErrorCollection errors = result.getErrorCollection();
                    for (String errorMsg : errors.getErrorMessages()) {
                        errorCollection.addError(fieldId, errorMsg, ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                    errorCollection.addError(fieldId, errors.getErrors().get("name"), ErrorCollection.Reason.VALIDATION_FAILED);
                    continue;
                }
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.invalid.version.id", version), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else {
            String bad = StringUtils.join(newVersionNames, (String)"");
            if (!StringUtils.isEmpty((String)bad)) {
                errorCollection.addError(fieldId, i18n.getText("issue.field.versions.invalid.version.id", bad), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    public List<Version> createNewVersions(Long projectId, Set<String> versionsToAdd) {
        ArrayList newVersions = Lists.newArrayList();
        for (String version : versionsToAdd) {
            try {
                Version newVersion = this.versionManager.createVersion(StringUtils.substring((String)version, (int)NEW_VERSION_RREFIX.length()), null, null, projectId, null);
                newVersions.add(newVersion);
            }
            catch (CreateException e) {
                throw new RuntimeException(e);
            }
        }
        return newVersions;
    }

    private Long getVersionIdAsLong(Object o) {
        Long l = o instanceof String ? new Long((String)o) : (Long)o;
        return l;
    }

    @VisibleForTesting
    VersionService getVersionService() {
        return ComponentAccessor.getComponentOfType(VersionService.class);
    }
}

