/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;

public class QueryCreationContextImpl
implements QueryCreationContext {
    private final ApplicationUser user;
    private final boolean securityOverriden;

    public QueryCreationContextImpl(ApplicationUser user) {
        this(user, false);
    }

    public QueryCreationContextImpl(ApplicationUser user, boolean securityOverriden) {
        this.user = user;
        this.securityOverriden = securityOverriden;
    }

    @Deprecated
    public QueryCreationContextImpl(User user) {
        this(ApplicationUsers.from(user), false);
    }

    @Deprecated
    public QueryCreationContextImpl(User user, boolean securityOverriden) {
        this(ApplicationUsers.from(user), securityOverriden);
    }

    @Override
    public ApplicationUser getApplicationUser() {
        return this.user;
    }

    @Override
    public User getUser() {
        return ApplicationUsers.toDirectoryUser(this.user);
    }

    @Override
    public User getQueryUser() {
        return ApplicationUsers.toDirectoryUser(this.user);
    }

    @Override
    public boolean isSecurityOverriden() {
        return this.securityOverriden;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryCreationContextImpl that = (QueryCreationContextImpl)o;
        if (this.securityOverriden != that.securityOverriden) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 31 * result + (this.securityOverriden ? 1 : 0);
        return result;
    }
}

