/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class MappedSortComparator
extends FieldComparatorSource {
    private final LuceneFieldSorter sorter;

    public MappedSortComparator(LuceneFieldSorter sorter) {
        this.sorter = sorter;
    }

    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new InternalFieldComparator(numHits, fieldname, this.sorter);
    }

    Object[] getLuceneValues(String field, IndexReader reader) throws IOException {
        return JiraLuceneFieldFinder.getInstance().getCustom(reader, field, this);
    }

    public Object getComparable(String termtext) {
        return this.sorter.getValueFromLuceneField(termtext);
    }

    public Comparator getComparator() {
        return this.sorter.getComparator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MappedSortComparator that = (MappedSortComparator)((Object)o);
        return this.sorter == null ? that.sorter == null : this.sorter.equals(that.sorter);
    }

    public int hashCode() {
        return this.sorter != null ? this.sorter.hashCode() : 0;
    }

    private class LazyValueFinder
    implements ValueFinder {
        private final IndexReader reader;
        private final String field;
        private final FieldSelector fieldSelector;
        private final Comparator comparator;
        private int lastDoc;
        private Object lastValue;

        LazyValueFinder(IndexReader reader, String field) {
            this.comparator = MappedSortComparator.this.getComparator();
            this.lastDoc = -1;
            this.lastValue = null;
            this.reader = reader;
            this.field = field;
            this.fieldSelector = new FieldSelector(){

                public FieldSelectorResult accept(String fieldName) {
                    if (LazyValueFinder.this.field.equals(fieldName)) {
                        return FieldSelectorResult.LOAD_AND_BREAK;
                    }
                    return FieldSelectorResult.NO_LOAD;
                }
            };
        }

        @Override
        public Object getValue(int doc) {
            if (doc == this.lastDoc) {
                return this.lastValue;
            }
            try {
                Document document = this.reader.document(doc, this.fieldSelector);
                Fieldable[] values = document.getFieldables(this.field);
                Object comparable = null;
                for (Fieldable field : values) {
                    Object value = MappedSortComparator.this.getComparable(field.stringValue());
                    if (comparable != null && this.comparator.compare(value, comparable) >= 1) continue;
                    comparable = value;
                }
                this.lastDoc = doc;
                this.lastValue = comparable;
                return comparable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class HungryValueFinder
    implements ValueFinder {
        private final IndexReader reader;
        private final String field;
        private boolean initialised = false;
        private Object[] currentDocumentValues;

        private HungryValueFinder(IndexReader reader, String field) {
            this.reader = reader;
            this.field = field;
        }

        @Override
        public Object getValue(int doc) throws IOException {
            if (!this.initialised) {
                this.currentDocumentValues = MappedSortComparator.this.getLuceneValues(this.field, this.reader);
                this.initialised = true;
            }
            return this.currentDocumentValues[doc];
        }
    }

    private static interface ValueFinder {
        public Object getValue(int var1) throws IOException;
    }

    public final class InternalFieldComparator
    extends FieldComparator {
        private Object[] values;
        private final int numHits;
        private final String field;
        private LuceneFieldSorter sorter;
        private Object bottom;
        private final Comparator comparator;
        private int resultsCount;
        private int fastDocThreshold;
        private ValueFinder hungryValueFinder;
        private ValueFinder lazyValueFinder;

        InternalFieldComparator(int numHits, String field, LuceneFieldSorter sorter) {
            this.numHits = numHits;
            int initSize = Math.min(1024, numHits);
            this.values = new Object[initSize];
            this.field = field;
            this.sorter = sorter;
            this.comparator = this.sorter.getComparator();
        }

        public int compare(int slot1, int slot2) {
            Object v1 = this.values[slot1];
            Object v2 = this.values[slot2];
            if (v1 == v2) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return this.comparator.compare(v1, v2);
        }

        public int compareBottom(int doc) {
            Object v2 = this.getDocumnetValue(doc);
            if (this.bottom == v2) {
                return 0;
            }
            if (this.bottom == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return this.comparator.compare(this.bottom, v2);
        }

        public void copy(int slot, int doc) {
            this.ensureCapacity(slot);
            this.values[slot] = this.getDocumnetValue(doc);
        }

        private void ensureCapacity(int slot) {
            if (this.values.length <= slot) {
                int newSize = Math.min(this.numHits, this.values.length * 2);
                if (newSize <= slot) {
                    newSize = slot + 1;
                }
                this.values = Arrays.copyOf(this.values, newSize);
            }
        }

        private Object getDocumnetValue(int doc) {
            ++this.resultsCount;
            try {
                if (this.resultsCount > this.fastDocThreshold) {
                    return this.hungryValueFinder.getValue(doc);
                }
                return this.lazyValueFinder.getValue(doc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.resultsCount = 0;
            this.fastDocThreshold = reader.numDocs() / 500;
            this.lazyValueFinder = new LazyValueFinder(reader, this.field);
            this.hungryValueFinder = new HungryValueFinder(reader, this.field);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable<?> value(int slot) {
            return null;
        }
    }
}

