/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.LazyMapEntry;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class CompositeMap<K, V>
extends AbstractMap<K, V> {
    final Map<K, V> one;
    final Map<K, V> two;
    final Set<Object> removed = Sets.newHashSet();
    private KeySet keySet = null;
    private EntrySet entrySet = null;

    public static <K, V> Map<K, V> of(Map<K, V> one, Map<K, V> two) {
        Assertions.notNull("one", one);
        return Assertions.notNull("two", two).isEmpty() ? one : new CompositeMap<K, V>(one, two);
    }

    private CompositeMap(Map<K, V> one, Map<K, V> two) {
        this.one = one;
        this.two = two;
    }

    @Override
    public Set<K> keySet() {
        KeySet keys = this.keySet;
        return keys != null ? keys : (this.keySet = new KeySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entries = this.entrySet;
        return entries != null ? entries : (this.entrySet = new EntrySet());
    }

    @Override
    public boolean isEmpty() {
        if (this.one.isEmpty()) {
            return this.removed.size() == this.two.size();
        }
        return false;
    }

    @Override
    public int size() {
        int count = this.one.size();
        for (K key : this.two.keySet()) {
            if (this.one.containsKey(key) || this.removed.contains(key)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.one.containsKey(key) || this.two.containsKey(key) && !this.removed.contains(key);
    }

    @Override
    public V get(Object key) {
        if (this.one.containsKey(key)) {
            return this.one.get(key);
        }
        return this.removed.contains(key) ? null : (V)this.two.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.one.containsKey(key)) {
            return this.one.put(key, value);
        }
        this.one.put(key, value);
        return this.two.containsKey(key) && this.removed.add(key) ? (V)this.two.get(key) : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.one.putAll(m);
        this.removed.removeAll(m.keySet());
    }

    @Override
    public V remove(Object key) {
        boolean inMapTwoAndNotYetRemoved;
        boolean bl = inMapTwoAndNotYetRemoved = this.two.containsKey(key) && this.removed.add(key);
        return this.one.containsKey(key) ? (V)this.one.remove(key) : (inMapTwoAndNotYetRemoved ? (V)this.two.get(key) : null);
    }

    private boolean eq(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    @Override
    public void clear() {
        this.one.clear();
        this.removed.addAll(this.two.keySet());
    }

    class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private final KeySetIterator keys;

        EntrySetIterator() {
            this.keys = new KeySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new LazyMapEntry(CompositeMap.this, this.keys.next());
        }

        @Override
        public void remove() {
            this.keys.remove();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return CompositeMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CompositeMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o;
                Object key = other.getKey();
                return CompositeMap.this.containsKey(key) && CompositeMap.this.eq(CompositeMap.this.get(key), other.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        private Set<Map.Entry<K, V>> snapshot() {
            return CollectionUtil.transformSet(CompositeMap.this.keySet(), new EntryTransformer());
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.snapshot().toArray(a);
        }

        @Override
        public boolean add(Map.Entry<K, V> kvEntry) {
            throw new UnsupportedOperationException("CompositeMap.EntrySet.add");
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException("CompositeMap.EntrySet.addAll");
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                CompositeMap.this.remove(((Map.Entry)o).getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            CompositeMap.this.clear();
        }
    }

    class EntryTransformer
    implements Function<K, Map.Entry<K, V>> {
        EntryTransformer() {
        }

        @Override
        public Map.Entry<K, V> get(K key) {
            return new LazyMapEntry(CompositeMap.this, key);
        }
    }

    class KeySetIterator
    implements Iterator<K> {
        private Iterator<K> iter;
        private K nextKey;
        private K thisKey;
        private boolean inMapOne;
        private boolean hasNext;
        private boolean hasThis;

        KeySetIterator() {
            this.iter = CompositeMap.this.one.keySet().iterator();
            this.nextKey = null;
            this.thisKey = null;
            this.inMapOne = true;
            this.hasNext = false;
            this.hasThis = false;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            if (this.inMapOne) {
                if (this.iter.hasNext()) {
                    this.nextKey = this.iter.next();
                    this.hasNext = true;
                    return true;
                }
                this.inMapOne = false;
                this.iter = CompositeMap.this.two.keySet().iterator();
            }
            while (this.iter.hasNext()) {
                Object key = this.iter.next();
                if (CompositeMap.this.one.containsKey(key) || CompositeMap.this.removed.contains(key)) continue;
                this.nextKey = key;
                this.hasNext = true;
                return true;
            }
            return false;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more keys in the set");
            }
            this.hasNext = false;
            this.hasThis = true;
            this.thisKey = this.nextKey;
            return this.thisKey;
        }

        @Override
        public void remove() {
            if (!this.hasThis) {
                throw new IllegalStateException("No current key");
            }
            this.hasThis = false;
            Object key = this.thisKey;
            if (this.inMapOne) {
                this.iter.remove();
                if (CompositeMap.this.two.containsKey(key)) {
                    CompositeMap.this.removed.add(key);
                }
            } else {
                CompositeMap.this.one.remove(key);
                CompositeMap.this.removed.add(key);
            }
        }
    }

    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        private ImmutableSet<K> snapshot() {
            return ImmutableSet.builder().addAll((Iterable)this).build();
        }

        @Override
        public int size() {
            return CompositeMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CompositeMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CompositeMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.snapshot().toArray((Object[])a);
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException("CompositeMap.KeySet.add");
        }

        @Override
        public boolean remove(Object o) {
            boolean foundInTwo;
            boolean bl = foundInTwo = CompositeMap.this.two.containsKey(o) && CompositeMap.this.removed.add(o);
            if (CompositeMap.this.one.containsKey(o)) {
                CompositeMap.this.one.remove(o);
                return true;
            }
            return foundInTwo;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object key : c) {
                if (CompositeMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException("CompositeMap.KeySet.addAll");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean changed = CompositeMap.this.one.keySet().retainAll(c);
            for (Object key : CompositeMap.this.two.keySet()) {
                if (c.contains(key) || !CompositeMap.this.removed.add(key)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = CompositeMap.this.one.keySet().removeAll(c);
            for (Object key : c) {
                if (!CompositeMap.this.two.containsKey(key) || !CompositeMap.this.removed.add(key)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            CompositeMap.this.clear();
        }
    }
}

