/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtilsBean;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.query.Query;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;
import webwork.action.Action;

@Internal
public abstract class AbstractSearchRenderer
implements SearchRenderer {
    private static final Logger log = Logger.getLogger(AbstractSearchRenderer.class);
    private static final String SEARCHER_TEMPLATE_DIRECTORY_PATH = "templates/jira/issue/searchers/";
    private static final String EDIT_TEMPLATE_DIRECTORY_PATH = "templates/jira/issue/searchers/edit/";
    private static final String VIEW_TEMPLATE_DIRECTORY_PATH = "templates/jira/issue/searchers/view/";
    protected static final String EDIT_TEMPLATE_SUFFIX = "-edit.vm";
    protected static final String VIEW_TEMPLATE_SUFFIX = "-view.vm";
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final VelocityTemplatingEngine velocityManager;
    private final String searcherId;
    private final String searcherNameKey;

    public AbstractSearchRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, SimpleFieldSearchConstants searchConstants, String searcherNameKey) {
        this(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants.getSearcherId(), searcherNameKey);
    }

    public AbstractSearchRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherId, String searcherNameKey) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.velocityManager = templatingEngine;
        this.searcherId = searcherId;
        this.searcherNameKey = searcherNameKey;
    }

    protected Map<String, Object> getVelocityParams(User searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        HashMap<String, Object> velocityParams = new HashMap<String, Object>(20);
        velocityParams.put("searchContext", searchContext);
        velocityParams.put("fieldValuesHolder", fieldValuesHolder);
        velocityParams.put("displayParameters", displayParameters);
        velocityParams.put("fieldLayoutItem", fieldLayoutItem);
        velocityParams.put("action", action);
        velocityParams.put("errors", action);
        velocityParams.put("isKickass", true);
        velocityParams.put("baseurl", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
        velocityParams.put("searcherId", this.searcherId);
        velocityParams.put("searcherNameKey", this.searcherNameKey);
        velocityParams.put("helpUtil", HelpUtil.getInstance());
        velocityParams.put("jirakeyutils", new JiraKeyUtilsBean());
        velocityParams.put("i18n", this.getI18n(searcher));
        velocityParams.put("dateFormat", CustomFieldUtils.getDateFormat());
        velocityParams.put("dateTimeFormat", CustomFieldUtils.getDateTimeFormat());
        velocityParams.put("timeFormat", CustomFieldUtils.getTimeFormat());
        velocityParams.put("auiparams", new HashMap());
        return CompositeMap.of(velocityParams, ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams(jiraAuthenticationContext));
    }

    protected String renderEditTemplate(String template, Map<String, Object> velocityParams) {
        try {
            return this.velocityManager.render(TemplateSources.file(EDIT_TEMPLATE_DIRECTORY_PATH + template)).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for 'templates/jira/issue/searchers/edit//" + template + "'."), (Throwable)e);
            return "";
        }
    }

    protected String renderViewTemplate(String template, Map<String, Object> velocityParams) {
        try {
            return this.velocityManager.render(TemplateSources.file(VIEW_TEMPLATE_DIRECTORY_PATH + template)).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for 'templates/jira/issue/searchers/view//" + template + "'."), (Throwable)e);
            return "";
        }
    }

    protected boolean isRelevantForQuery(ClauseNames clauseNames, Query query) {
        if (query != null && query.getWhereClause() != null) {
            NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor(clauseNames.getJqlFieldNames());
            query.getWhereClause().accept(clauseVisitor);
            return clauseVisitor.containsNamedClause();
        }
        return false;
    }

    protected I18nHelper getI18n(User searcher) {
        return ComponentAccessor.getComponent(I18nHelper.BeanFactory.class).getInstance(searcher);
    }
}

