/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String name;
    @JsonProperty
    private String key;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private Map<String, String> avatarUrls;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;
    public static final UserJsonBean USER_DOC_EXAMPLE = new UserJsonBean();
    public static final UserJsonBean USER_SHORT_DOC_EXAMPLE = new UserJsonBean();

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Deprecated
    public void setEmailAddress(String emailAddress) {
        this.setEmailAddress(emailAddress, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public void setEmailAddress(String emailAddress, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        this.emailAddress = emailFormatter.formatEmail(emailAddress, loggedInUser != null ? loggedInUser.getDirectoryUser() : null);
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public void setAvatarUrls(Map<String, String> avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<User> users, JiraBaseUrls urls) {
        return UserJsonBean.shortBeans(users, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static Collection<UserJsonBean> shortBeans(Collection<User> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        if (users == null) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)users.size());
        for (User from : users) {
            result.add(UserJsonBean.shortBean(from, urls, loggedInUser, emailFormatter));
        }
        return result;
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls) {
        return UserJsonBean.shortBeanCollection(users, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        if (users == null) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)users.size());
        for (ApplicationUser from : users) {
            result.add(UserJsonBean.shortBean(from, urls, loggedInUser, emailFormatter));
        }
        return result;
    }

    @Deprecated
    public static UserJsonBean shortBean(User user, JiraBaseUrls urls) {
        return UserJsonBean.shortBean(user, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static UserJsonBean shortBean(User user, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        if (user == null) {
            return null;
        }
        UserJsonBean bean = new UserJsonBean();
        bean.self = urls.restApi2BaseUrl() + "user?username=" + JiraUrlCodec.encode(user.getName());
        bean.name = user.getName();
        bean.displayName = user.getDisplayName();
        bean.emailAddress = emailFormatter.formatEmail(user, loggedInUser != null ? loggedInUser.getDirectoryUser() : null);
        bean.active = user.isActive();
        bean.avatarUrls = UserJsonBean.getAvatarURLs(user);
        return bean;
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser user, JiraBaseUrls urls) {
        return UserJsonBean.shortBean(user, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static UserJsonBean shortBean(ApplicationUser user, JiraBaseUrls urls, ApplicationUser currentUser, EmailFormatter emailFormatter) {
        if (user == null) {
            return null;
        }
        UserJsonBean bean = new UserJsonBean();
        bean.self = urls.restApi2BaseUrl() + "user?username=" + JiraUrlCodec.encode(user.getUsername());
        bean.name = user.getUsername();
        bean.displayName = user.getDisplayName();
        bean.emailAddress = emailFormatter.formatEmail(user.getEmailAddress(), currentUser != null ? currentUser.getDirectoryUser() : null);
        bean.active = user.isActive();
        bean.avatarUrls = UserJsonBean.getAvatarURLs(user);
        return bean;
    }

    private static Map<String, String> getAvatarURLs(User user) {
        return UserJsonBean.getAvatarURLs(ApplicationUsers.from(user));
    }

    private static Map<String, String> getAvatarURLs(ApplicationUser user) {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        HashMap<String, String> avatarUrls = new HashMap<String, String>();
        for (Avatar.Size size : Avatar.Size.values()) {
            int px = size.getPixels();
            if (px > 48) continue;
            String sizeName = String.format("%dx%d", px, px);
            avatarUrls.put(sizeName, avatarService.getAvatarAbsoluteURL(user, user, size).toString());
        }
        return avatarUrls;
    }

    static {
        USER_DOC_EXAMPLE.setSelf("http://www.example.com/jira/rest/api/2/user?username=fred");
        USER_DOC_EXAMPLE.setName("fred");
        UserJsonBean.USER_DOC_EXAMPLE.emailAddress = "fred@example.com";
        USER_DOC_EXAMPLE.setDisplayName("Fred F. User");
        USER_DOC_EXAMPLE.setActive(true);
        USER_DOC_EXAMPLE.setAvatarUrls(MapBuilder.newBuilder().add("16x16", "http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred").add("24x24", "http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred").add("32x32", "http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred").add("48x48", "http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred").toMap());
        USER_SHORT_DOC_EXAMPLE.setSelf(USER_DOC_EXAMPLE.getSelf());
        USER_SHORT_DOC_EXAMPLE.setName(USER_DOC_EXAMPLE.getName());
        USER_SHORT_DOC_EXAMPLE.setDisplayName(USER_DOC_EXAMPLE.getDisplayName());
    }
}

