/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.web.ui.header.CurrentHeader;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import org.apache.commons.lang.StringUtils;

public class LookAndFeelBean {
    private final ApplicationProperties applicationProperties;

    @Deprecated
    public boolean isCommonHeader() {
        return true;
    }

    protected CurrentHeader getCurrentHeader() {
        return ComponentAccessor.getComponent(CurrentHeader.class);
    }

    protected LookAndFeelBean(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public static LookAndFeelBean getInstance(ApplicationProperties ap) {
        return new LookAndFeelBean(ap);
    }

    private void incrementVersion() {
        long version = this.getVersion();
        this.updateFlushCounter(++version);
    }

    private void updateFlushCounter(long version) {
        this.applicationProperties.setString("jira.webresource.flushcounter", Long.toString(version));
        EventPublisher publisher = ComponentAccessor.getComponent(EventPublisher.class);
        if (publisher != null) {
            publisher.publish((Object)new LookAndFeelChangedEvent());
        }
    }

    public String stripHash(String colour) {
        if (StringUtils.isNotBlank((String)colour) && colour.startsWith("#")) {
            return colour.substring(1, colour.length());
        }
        return colour;
    }

    private void setValue(String key, String value) {
        this.applicationProperties.setString(key, value);
        this.incrementVersion();
    }

    public void updateVersion(long oldVersion) {
        long currentVersion = this.getVersion();
        if (oldVersion > currentVersion) {
            this.updateFlushCounter(++oldVersion);
        } else {
            this.updateFlushCounter(++currentVersion);
        }
    }

    public long getVersion() {
        String editVersion = this.applicationProperties.getDefaultBackedString("jira.webresource.flushcounter");
        return Long.parseLong(StringUtils.isNotEmpty((String)editVersion) ? editVersion : "1");
    }

    public String getLogoUrl() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.logo.url");
    }

    public String getAbsoluteLogoUrl() {
        String jiraLogo = this.getLogoUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = ComponentAccessor.getComponent(WebResourceUrlProvider.class).getStaticResourcePrefix(UrlMode.AUTO) + jiraLogo;
        }
        return jiraLogo;
    }

    public void setLogoUrl(String logoUrl) {
        this.setValue("jira.lf.logo.url", logoUrl);
    }

    public String getLogoWidth() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.logo.width");
    }

    public String getLogoPixelWidth() {
        return this.getLogoWidth() + "px";
    }

    public void setLogoWidth(String logoWidth) {
        this.setValue("jira.lf.logo.width", logoWidth);
    }

    public String getLogoHeight() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.logo.height");
    }

    public String getLogoPixelHeight() {
        return this.getLogoHeight() + "px";
    }

    public void setLogoHeight(String logoHeight) {
        this.setValue("jira.lf.logo.height", logoHeight);
    }

    public String getFaviconUrl() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.favicon.url");
    }

    public void setFaviconUrl(String faviconUrl) {
        this.setValue("jira.lf.favicon.url", faviconUrl);
    }

    public String getFaviconWidth() {
        return "16";
    }

    public String getFaviconHeight() {
        return "16";
    }

    public String getFaviconHiResUrl() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.favicon.hires.url");
    }

    public void setFaviconHiResUrl(String faviconUrl) {
        this.setValue("jira.lf.favicon.hires.url", faviconUrl);
    }

    public String getFaviconHiResWidth() {
        return "32";
    }

    public String getFaviconHiResHeight() {
        return "32";
    }

    public String getTopBackgroundColour() {
        String defaultColour = "#205081";
        return this.getDefaultBackedString("jira.lf.top.bgcolour", defaultColour);
    }

    public void setTopBackgroundColour(String topBackgroundColour) {
        this.setValue("jira.lf.top.bgcolour", topBackgroundColour);
    }

    public String getTopTxtColour() {
        return this.getDefaultBackedString("jira.lf.top.textcolour", "#ffffff");
    }

    public void setTopTxtColour(String topTxtColour) {
        this.setValue("jira.lf.top.textcolour", topTxtColour);
    }

    public String getTopHighlightColor() {
        String defaultColour = "#296ca3";
        return this.getDefaultBackedString("jira.lf.top.hilightcolour", defaultColour);
    }

    public void setTopHighlightColor(String newValue) {
        this.setValue("jira.lf.top.hilightcolour", newValue);
    }

    public String getTopTextHighlightColor() {
        return this.getDefaultBackedString("jira.lf.top.texthilightcolour", "#f0f0f0");
    }

    public void setTopTextHighlightColor(String newValue) {
        this.setValue("jira.lf.top.texthilightcolour", newValue);
    }

    public String getTopSeparatorBackgroundColor() {
        String defaultColour = "#2e3d54";
        return this.getDefaultBackedString("jira.lf.top.separator.bgcolor", defaultColour);
    }

    public void setTopSeparatorBackgroundColor(String newValue) {
        this.setValue("jira.lf.top.separator.bgcolor", newValue);
    }

    public String getMenuTxtColour() {
        return this.getDefaultBackedString("jira.lf.menu.textcolour", "#ffffff");
    }

    public void setMenuTxtColour(String menuTxtColour) {
        this.setValue("jira.lf.menu.textcolour", menuTxtColour);
    }

    public String getMenuBackgroundColour() {
        return this.getDefaultBackedString("jira.lf.menu.bgcolour", "#3b73af");
    }

    public void setMenuBackgroundColour(String menuBackgroundColour) {
        this.setValue("jira.lf.menu.bgcolour", menuBackgroundColour);
    }

    public String getMenuSeparatorColour() {
        return this.getDefaultBackedString("jira.lf.menu.separator", "#f0f0f0");
    }

    public void setMenuSeparatorColour(String menuSeparatorColour) {
        this.setValue("jira.lf.menu.separator", menuSeparatorColour);
    }

    public String getTextHeadingColour() {
        return this.getDefaultBackedString("jira.lf.text.headingcolour", "#333333");
    }

    public void setTextHeadingColour(String textHeadingColour) {
        this.setValue("jira.lf.text.headingcolour", textHeadingColour);
    }

    public String getTextLinkColour() {
        return this.getDefaultBackedString("jira.lf.text.linkcolour", "#3b73af");
    }

    public void setTextLinkColour(String textLinkColour) {
        this.setValue("jira.lf.text.linkcolour", textLinkColour);
    }

    public String getTextActiveLinkColour() {
        return this.getDefaultBackedString("jira.lf.text.activelinkcolour", "#3b73af");
    }

    public void setTextActiveLinkColour(String textActiveLinkColour) {
        this.setValue("jira.lf.text.activelinkcolour", textActiveLinkColour);
    }

    public String getHeroButtonTextColour() {
        return this.getDefaultBackedString("jira.lf.hero.button.text.colour", "#ffffff");
    }

    public void setHeroButtonTextColour(String heroButtonTextColour) {
        this.setValue("jira.lf.hero.button.text.colour", heroButtonTextColour);
    }

    public String getHeroButtonBaseBGColour() {
        return this.getDefaultBackedString("jira.lf.hero.button.base.bg.colour", "#3b7fc4");
    }

    public void setHeroButtonBaseBGColour(String heroButtonBaseBGColour) {
        this.setValue("jira.lf.hero.button.base.bg.colour", heroButtonBaseBGColour);
    }

    public String getGadgetChromeColor(String id) {
        return this.applicationProperties.getDefaultBackedString("jira.lf.gadget." + id);
    }

    public void setGadgetChromeColor(String id, String gadgetChromeColor) {
        this.setValue("jira.lf.gadget." + id, gadgetChromeColor);
    }

    public String getApplicationID() {
        return this.applicationProperties.getDefaultBackedString("jira.lf.application.id");
    }

    public String getDefaultBackedString(String key, String defaultValue) {
        String value = this.applicationProperties.getString(key);
        return value == null ? defaultValue : value;
    }

    public String getDefaultBackedString(String key) {
        if (key == null) {
            return null;
        }
        if (this.applicationProperties.getString(key) != null) {
            return this.applicationProperties.getString(key);
        }
        return this.applicationProperties.getDefaultBackedString(key);
    }

    public static class DefaultFaviconDimensions {
        public static final String FAVICON_DIMENSION = "16";
        public static final String FAVICON_HIRES_DIMENSION = "32";

        private DefaultFaviconDimensions() {
        }
    }

    public static final class DefaultCommonColours {
        public static final String TOP_HIGHLIGHTCOLOUR = "#296ca3";
        public static final String TOP_SEPARATOR_BGCOLOUR = "#2e3d54";
        public static final String TOP_BGCOLOUR = "#205081";
        public static final String HERO_BUTTON_TXTCOLOUR = "#ffffff";
        public static final String HERO_BUTTON_BASEBGCOLOUR = "#3b7fc4";

        private DefaultCommonColours() {
        }
    }

    public static final class DefaultColours {
        public static final String TOP_HIGHLIGHTCOLOUR = "#296ca3";
        public static final String TOP_TEXTHIGHLIGHTCOLOUR = "#f0f0f0";
        public static final String TOP_SEPARATOR_BGCOLOUR = "#2e3d54";
        public static final String TOP_BGCOLOUR = "#205081";
        public static final String TOP_TEXTCOLOUR = "#ffffff";
        public static final String MENU_BGCOLOUR = "#3b73af";
        public static final String MENU_TEXTCOLOUR = "#ffffff";
        public static final String MENU_SEPARATOR = "#f0f0f0";
        public static final String TEXT_LINKCOLOR = "#3b73af";
        public static final String TEXT_ACTIVELINKCOLOR = "#3b73af";
        public static final String TEXT_HEADINGCOLOR = "#333333";

        private DefaultColours() {
        }
    }

    public static class LookAndFeelChangedEvent {
    }
}

