/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.PercentageContext;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Internal
class CompositeSink
implements PercentageContext.Sink {
    private final List<PercentageContext.Sink> delegates;

    CompositeSink(PercentageContext.Sink ... delegates) {
        Assertions.notNull("delegates", delegates);
        this.delegates = Collections.unmodifiableList(Arrays.asList(delegates));
    }

    @Override
    public void setName(String name) {
        Assertions.notNull("name", name);
        Iterator<PercentageContext.Sink> i$ = this.delegates.iterator();
        while (i$.hasNext()) {
            PercentageContext.Sink element;
            PercentageContext.Sink delegate = element = i$.next();
            delegate.setName(name);
        }
    }

    @Override
    public void updateProgress(int progress) {
        Iterator<PercentageContext.Sink> i$ = this.delegates.iterator();
        while (i$.hasNext()) {
            PercentageContext.Sink element;
            PercentageContext.Sink delegate = element = i$.next();
            delegate.updateProgress(progress);
        }
    }
}

