/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

public class UserIndexInfoResolver
implements IndexInfoResolver<User> {
    private final NameResolver<User> userResolver;

    public UserIndexInfoResolver(NameResolver<User> userResolver) {
        this.userResolver = userResolver;
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        return this.userResolver.getIdsFromName(Assertions.notNull("rawValue", rawValue));
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        return this.getIndexedValues(Assertions.notNull("rawValue", rawValue).toString());
    }

    @Override
    public String getIndexedValue(User user) {
        return this.getUserKeyService().getKeyForUsername(Assertions.notNull("user", user).getName());
    }

    UserKeyService getUserKeyService() {
        return ComponentAccessor.getComponentOfType(UserKeyService.class);
    }
}

