/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.project;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.google.common.base.Objects;

public class ProjectCategoryChangeEvent {
    private Project project;
    private ProjectCategory oldProjectCategory;
    private ProjectCategory newProjectCategory;

    private ProjectCategoryChangeEvent(Project project, ProjectCategory oldProjectCategory, ProjectCategory newProjectCategory) {
        this.project = project;
        this.oldProjectCategory = oldProjectCategory;
        this.newProjectCategory = newProjectCategory;
    }

    public Project getProject() {
        return this.project;
    }

    public ProjectCategory getOldProjectCategory() {
        return this.oldProjectCategory;
    }

    public ProjectCategory getNewProjectCategory() {
        return this.newProjectCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCategoryChangeEvent that = (ProjectCategoryChangeEvent)o;
        if (this.newProjectCategory != null ? !this.newProjectCategory.equals(that.newProjectCategory) : that.newProjectCategory != null) {
            return false;
        }
        if (this.oldProjectCategory != null ? !this.oldProjectCategory.equals(that.oldProjectCategory) : that.oldProjectCategory != null) {
            return false;
        }
        return !(this.project != null ? !this.project.equals(that.project) : that.project != null);
    }

    public int hashCode() {
        int result = this.project != null ? this.project.hashCode() : 0;
        result = 31 * result + (this.oldProjectCategory != null ? this.oldProjectCategory.hashCode() : 0);
        result = 31 * result + (this.newProjectCategory != null ? this.newProjectCategory.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private ProjectCategory oldCategory;
        private ProjectCategory newCategory;
        private Project project;

        public Builder(Project project) {
            this.project = project;
        }

        public Builder addOldCategory(ProjectCategory projectCategory) {
            this.oldCategory = projectCategory;
            return this;
        }

        public Builder addNewCategory(ProjectCategory projectCategory) {
            this.newCategory = projectCategory;
            return this;
        }

        public Builder addProject(Project project) {
            this.project = project;
            return this;
        }

        public ProjectCategoryChangeEvent build() {
            return new ProjectCategoryChangeEvent(this.project, this.oldCategory, this.newCategory);
        }

        public boolean canBePublished() {
            return this.newCategory != null && this.oldCategory == null || this.newCategory == null && this.oldCategory != null || this.newCategory != null && this.oldCategory != null && !Objects.equal((Object)this.newCategory.getId(), (Object)this.oldCategory.getId());
        }
    }
}

