/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachmentJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String filename;
    @JsonProperty
    private UserJsonBean author;
    @XmlJavaTypeAdapter(value=Dates.DateTimeAdapter.class)
    private Date created;
    @JsonProperty
    private long size;
    @JsonProperty
    private String mimeType;
    @JsonProperty
    private String content;
    @JsonProperty
    private String thumbnail;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public void setAuthor(UserJsonBean author) {
        this.author = author;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public static Collection<AttachmentJsonBean> shortBeans(Collection<Attachment> attachments, JiraBaseUrls urls, ThumbnailManager thumbnailManager) {
        ArrayList result = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Attachment from : attachments) {
            result.add(AttachmentJsonBean.shortBean(from, urls, thumbnailManager));
        }
        return result;
    }

    public static AttachmentJsonBean shortBean(Attachment attachment, JiraBaseUrls urls, ThumbnailManager thumbnailManager) {
        AttachmentJsonBean bean;
        if (attachment == null) {
            return null;
        }
        try {
            bean = new AttachmentJsonBean();
            bean.self = urls.restApi2BaseUrl() + "attachment/" + JiraUrlCodec.encode(attachment.getId().toString());
            bean.id = attachment.getId().toString();
            bean.filename = attachment.getFilename();
            bean.size = attachment.getFilesize();
            bean.mimeType = attachment.getMimetype();
            ApplicationUser author = attachment.getAuthorObject();
            bean.author = UserJsonBean.shortBean(author, urls);
            bean.content = attachment.getFilename();
            bean.created = attachment.getCreated();
            String encodedFilename = URLEncoder.encode(attachment.getFilename(), "UTF-8");
            bean.content = String.format("%s/secure/attachment/%s/%s", urls.baseUrl(), attachment.getId(), encodedFilename);
            ThumbnailedImage thumbnail = thumbnailManager.toThumbnailedImage(thumbnailManager.getThumbnail(attachment.getIssueObject(), attachment));
            if (thumbnail != null) {
                bean.thumbnail = thumbnail.getImageURL();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding file name", e);
        }
        return bean;
    }
}

