/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.dbc;

import com.atlassian.annotations.PublicApi;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public final class Assertions {
    public static <T> T notNull(String name, T notNull) throws IllegalArgumentException {
        if (notNull == null) {
            throw new NullArgumentException(name);
        }
        return notNull;
    }

    public static <T> T notNull(T notNull) throws IllegalArgumentException {
        if (notNull == null) {
            throw new NullArgumentException("parameter");
        }
        return notNull;
    }

    public static <T extends Collection> T notEmpty(String name, T notEmpty) throws IllegalArgumentException {
        if (notEmpty == null) {
            throw new NullArgumentException(name);
        }
        if (notEmpty.isEmpty()) {
            throw new EmptyArgumentException(name);
        }
        return notEmpty;
    }

    public static <C extends Iterable<?>> C containsNoNulls(String name, C containsNoNulls) throws IllegalArgumentException {
        Assertions.notNull(name, containsNoNulls);
        int i = 0;
        for (Object item : containsNoNulls) {
            if (item == null) {
                throw new NullArgumentException(name + "[" + i + "]");
            }
            ++i;
        }
        return containsNoNulls;
    }

    public static <C> C[] containsNoNulls(String name, C[] containsNoNulls) throws IllegalArgumentException {
        Assertions.notNull(name, containsNoNulls);
        int i = 0;
        for (C item : containsNoNulls) {
            if (item == null) {
                throw new NullArgumentException(name + "[" + i + "]");
            }
            ++i;
        }
        return containsNoNulls;
    }

    public static String notBlank(String name, String string) throws IllegalArgumentException {
        Assertions.notNull(name, string);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new BlankStringArgumentException(name);
        }
        return string;
    }

    public static String stripNotBlank(String name, String string) throws IllegalArgumentException {
        Assertions.notNull(name, string);
        String result = StringUtils.stripToNull((String)string);
        if (result == null) {
            throw new BlankStringArgumentException(name);
        }
        return result;
    }

    public static <C extends Iterable<String>> C containsNoBlanks(String name, C stringsNotBlank) {
        Assertions.notNull(name, stringsNotBlank);
        int i = 0;
        for (String item : stringsNotBlank) {
            if (StringUtils.isBlank((CharSequence)item)) {
                throw new BlankStringArgumentException(name + "[" + i + "]");
            }
            ++i;
        }
        return stringsNotBlank;
    }

    public static void not(String name, boolean condition) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(name);
        }
    }

    public static void is(String name, boolean condition) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(name);
        }
    }

    public static void stateTrue(String name, boolean condition) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(name);
        }
    }

    public static void stateFalse(String name, boolean condition) throws IllegalStateException {
        if (condition) {
            throw new IllegalStateException(name);
        }
    }

    public static <T> T stateNotNull(String name, T notNull) {
        if (notNull == null) {
            throw new NullStateException(name);
        }
        return notNull;
    }

    public static <T> T equals(String name, T expected, T got) throws IllegalArgumentException {
        if (!expected.equals(got)) {
            throw new IllegalArgumentException(name + ". Expected:" + expected + " but got: " + got);
        }
        return got;
    }

    private Assertions() {
    }

    static class NullStateException
    extends IllegalStateException {
        NullStateException(String name) {
            super(name + " should not be null!");
        }
    }

    static class EmptyArgumentException
    extends IllegalArgumentException {
        EmptyArgumentException(String name) {
            super(name + " should not be empty!");
        }
    }

    static class NullArgumentException
    extends IllegalArgumentException {
        NullArgumentException(String name) {
            super(name + " should not be null!");
        }
    }

    static class BlankStringArgumentException
    extends IllegalArgumentException {
        BlankStringArgumentException(String name) {
            super(name + " should not be empty!");
        }
    }
}

