/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.PathTraversalException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String appendFileSeparator(String filePath) {
        return filePath == null ? null : (filePath.endsWith("/") || filePath.endsWith("\\") ? filePath : filePath + File.separator);
    }

    public static String joinPaths(String ... paths) {
        return StringUtils.join((Object[])paths, (String)File.separator);
    }

    public static void ensurePathInSecureDir(String secureDir, String untrustedPath) throws PathTraversalException, IOException {
        if (!PathUtils.isPathInSecureDir(secureDir, untrustedPath)) {
            throw new PathTraversalException();
        }
    }

    public static boolean isPathInSecureDir(String secureDir, String untrustedPath) throws IOException {
        String canonicalSecureDir = new File(secureDir).getCanonicalPath();
        String canonicalUntrustedPath = new File(untrustedPath).getCanonicalPath();
        return canonicalUntrustedPath.startsWith(canonicalSecureDir);
    }
}

