/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.statistics.AssigneeStatisticsMapper;
import com.atlassian.jira.issue.statistics.ComponentStatisticsMapper;
import com.atlassian.jira.issue.statistics.CreatorStatisticsMapper;
import com.atlassian.jira.issue.statistics.FixForVersionStatisticsMapper;
import com.atlassian.jira.issue.statistics.IssueTypeStatisticsMapper;
import com.atlassian.jira.issue.statistics.LabelsStatisticsMapper;
import com.atlassian.jira.issue.statistics.PriorityStatisticsMapper;
import com.atlassian.jira.issue.statistics.ProjectStatisticsMapper;
import com.atlassian.jira.issue.statistics.RaisedInVersionStatisticsMapper;
import com.atlassian.jira.issue.statistics.ReporterStatisticsMapper;
import com.atlassian.jira.issue.statistics.ResolutionStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.StatusStatisticsMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class FilterStatisticsValuesGenerator
implements ValuesGenerator {
    protected static final Map<String, String> systemValues;
    public static final String COMPONENTS = "components";
    public static final String FIXFOR = "fixfor";
    public static final String ALLFIXFOR = "allFixfor";
    public static final String VERSION = "version";
    public static final String ALLVERSION = "allVersion";
    public static final String ASSIGNEES = "assignees";
    public static final String ISSUETYPE = "issuetype";
    public static final String PRIORITIES = "priorities";
    public static final String PROJECT = "project";
    public static final String REPORTER = "reporter";
    public static final String RESOLUTION = "resolution";
    public static final String STATUSES = "statuses";
    public static final String LABELS = "labels";
    public static final String CREATOR = "creator";
    public static final Object IRRELEVANT;
    CustomFieldManager customFieldManager = ComponentAccessor.getComponent(CustomFieldManager.class);

    @Override
    public Map getValues(Map params) {
        ListOrderedMap allValues = new ListOrderedMap();
        allValues.putAll(systemValues);
        List<CustomField> customFieldObjects = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFieldObjects) {
            if (!(customField.getCustomFieldSearcher() instanceof CustomFieldStattable)) continue;
            allValues.put(customField.getId(), customField.getName());
        }
        return allValues;
    }

    public StatisticsMapper getStatsMapper(String statsMapperKey) {
        StatisticsMapper systemMapper = this.getSystemMapper(statsMapperKey);
        if (systemMapper != null) {
            return systemMapper;
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(statsMapperKey);
        if (customField == null) {
            throw new RuntimeException("No custom field with id " + statsMapperKey);
        }
        if (customField.getCustomFieldSearcher() instanceof CustomFieldStattable) {
            CustomFieldStattable customFieldStattable = (CustomFieldStattable)((Object)customField.getCustomFieldSearcher());
            return customFieldStattable.getStatisticsMapper(customField);
        }
        return null;
    }

    private StatisticsMapper getSystemMapper(String statsMapperKey) {
        if (COMPONENTS.equals(statsMapperKey)) {
            return new ComponentStatisticsMapper();
        }
        if (ASSIGNEES.equals(statsMapperKey)) {
            return new AssigneeStatisticsMapper(ComponentAccessor.getUserManager(), ComponentAccessor.getJiraAuthenticationContext());
        }
        if (ISSUETYPE.equals(statsMapperKey)) {
            return new IssueTypeStatisticsMapper(ComponentAccessor.getConstantsManager());
        }
        if (FIXFOR.equals(statsMapperKey)) {
            return new FixForVersionStatisticsMapper(ComponentAccessor.getVersionManager(), false);
        }
        if (ALLFIXFOR.equals(statsMapperKey)) {
            return new FixForVersionStatisticsMapper(ComponentAccessor.getVersionManager(), true);
        }
        if (PRIORITIES.equals(statsMapperKey)) {
            return new PriorityStatisticsMapper(ComponentAccessor.getConstantsManager());
        }
        if (PROJECT.equals(statsMapperKey)) {
            return new ProjectStatisticsMapper(ComponentAccessor.getProjectManager());
        }
        if (VERSION.equals(statsMapperKey)) {
            return new RaisedInVersionStatisticsMapper(ComponentAccessor.getVersionManager(), false);
        }
        if (ALLVERSION.equals(statsMapperKey)) {
            return new RaisedInVersionStatisticsMapper(ComponentAccessor.getVersionManager(), true);
        }
        if (REPORTER.equals(statsMapperKey)) {
            return new ReporterStatisticsMapper(ComponentAccessor.getUserManager(), ComponentAccessor.getJiraAuthenticationContext());
        }
        if (CREATOR.equals(statsMapperKey)) {
            return new CreatorStatisticsMapper(ComponentAccessor.getUserManager(), ComponentAccessor.getJiraAuthenticationContext());
        }
        if (RESOLUTION.equals(statsMapperKey)) {
            return new ResolutionStatisticsMapper(ComponentAccessor.getConstantsManager());
        }
        if (STATUSES.equals(statsMapperKey)) {
            return new StatusStatisticsMapper(ComponentAccessor.getConstantsManager());
        }
        if (LABELS.equals(statsMapperKey)) {
            return new LabelsStatisticsMapper(false);
        }
        return null;
    }

    static {
        IRRELEVANT = new Object();
        ListOrderedMap systemValuesTmp = new ListOrderedMap();
        systemValuesTmp.put(ASSIGNEES, "gadget.filterstats.field.statistictype.assignees");
        systemValuesTmp.put(COMPONENTS, "gadget.filterstats.field.statistictype.components");
        systemValuesTmp.put(ISSUETYPE, "gadget.filterstats.field.statistictype.issuetype");
        systemValuesTmp.put(FIXFOR, "gadget.filterstats.field.statistictype.fixfor");
        systemValuesTmp.put(ALLFIXFOR, "gadget.filterstats.field.statistictype.allfixfor");
        systemValuesTmp.put(PRIORITIES, "gadget.filterstats.field.statistictype.priorities");
        systemValuesTmp.put(PROJECT, "gadget.filterstats.field.statistictype.project");
        systemValuesTmp.put(VERSION, "gadget.filterstats.field.statistictype.version");
        systemValuesTmp.put(ALLVERSION, "gadget.filterstats.field.statistictype.allversion");
        systemValuesTmp.put(REPORTER, "gadget.filterstats.field.statistictype.reporter");
        systemValuesTmp.put(RESOLUTION, "gadget.filterstats.field.statistictype.resolution");
        systemValuesTmp.put(STATUSES, "gadget.filterstats.field.statistictype.statuses");
        systemValuesTmp.put(LABELS, "gadget.filterstats.field.statistictype.labels");
        systemValuesTmp.put(CREATOR, "gadget.filterstats.field.statistictype.creator");
        systemValues = Collections.unmodifiableMap(systemValuesTmp);
    }
}

