/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import org.ofbiz.core.entity.GenericValue;

public class GlobalPermissionEntry {
    private final String globalPermissionType;
    private final String group;

    public GlobalPermissionEntry(GenericValue permission) {
        this.group = permission.getString("group_id");
        this.globalPermissionType = permission.getString("permission");
    }

    public GlobalPermissionEntry(String globalPermissionType, String group) {
        this.globalPermissionType = globalPermissionType;
        this.group = group;
    }

    public GlobalPermissionEntry(String globalPermissionType) {
        this.globalPermissionType = globalPermissionType;
        this.group = null;
    }

    public String getGlobalPermissionType() {
        return this.globalPermissionType;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalPermissionEntry)) {
            return false;
        }
        GlobalPermissionEntry jiraPermission = (GlobalPermissionEntry)o;
        if (this.group != null ? !this.group.equals(jiraPermission.group) : jiraPermission.group != null) {
            return false;
        }
        return !(this.globalPermissionType != null ? !this.globalPermissionType.equals(jiraPermission.globalPermissionType) : jiraPermission.globalPermissionType != null);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 71 * result + (this.globalPermissionType != null ? this.globalPermissionType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Global Permission: [group=" + this.group + "][permType=" + this.globalPermissionType + "]";
    }
}

