/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.WithKey;
import com.atlassian.jira.entity.property.BaseEntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyHelper;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyService;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;

@ExperimentalApi
public class BaseEntityWithKeyPropertyService<E extends WithKey & WithId>
extends BaseEntityPropertyService<E>
implements EntityWithKeyPropertyService<E> {
    private final EntityWithKeyPropertyHelper<E> entityHelper;

    public BaseEntityWithKeyPropertyService(JsonEntityPropertyManager jsonEntityPropertyManager, I18nHelper i18n, EventPublisher eventPublisher, EntityWithKeyPropertyHelper<E> entityHelper) {
        super(jsonEntityPropertyManager, i18n, eventPublisher, entityHelper);
        this.entityHelper = entityHelper;
    }

    @Override
    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, String entityKey, EntityPropertyService.PropertyInput propertyInput) {
        return this.validateSetProperty(user, this.getEntity(entityKey), propertyInput);
    }

    @Override
    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, String entityKey, String propertyKey) {
        return this.validateDeleteProperty(user, this.getEntity(entityKey), propertyKey);
    }

    @Override
    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, String entityKey, String propertyKey) {
        return this.getProperty(user, this.getEntity(entityKey), propertyKey);
    }

    @Override
    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, String entityKey) {
        return this.getPropertiesKeys(user, this.getEntity(entityKey));
    }

    private Option<E> getEntity(String entityKey) {
        return (Option)this.entityHelper.getEntityByKeyFunction().apply((Object)entityKey);
    }
}

