/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractLocalDateOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RangeQueryFactory;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.util.Function;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.log4j.Logger;

public class LocalDateRelationalQueryFactory
extends AbstractLocalDateOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(LocalDateRelationalQueryFactory.class);
    private final RangeQueryFactory<LocalDate> rangeQueryFactory;

    public LocalDateRelationalQueryFactory(final JqlLocalDateSupport jqlLocalDateSupport) {
        super(jqlLocalDateSupport);
        this.rangeQueryFactory = new RangeQueryFactory<LocalDate>(new Function<LocalDate, String>(){

            @Override
            public String get(LocalDate date) {
                return jqlLocalDateSupport.getIndexedValue(date);
            }
        });
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug((Object)String.format("LocalDate operands do not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<LocalDate> dates = this.getLocalDateValues(rawValues);
        if (dates.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        LocalDate value = dates.get(0);
        if (value == null) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult(this.rangeQueryFactory.get(operator, fieldName, value));
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug((Object)"Multi value operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug((Object)"Empty operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

