/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class IndexDocumentConfiguration {
    private final String entityKey;
    private final List<KeyConfiguration> keyConfigurations;

    public IndexDocumentConfiguration(String entityKey, List<KeyConfiguration> keyConfigurations) {
        this.entityKey = (String)Preconditions.checkNotNull((Object)entityKey, (Object)"entityKey");
        this.keyConfigurations = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(keyConfigurations, (Object)"keyConfigurations")));
    }

    public List<KeyConfiguration> getKeyConfigurations() {
        return this.keyConfigurations;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public Iterable<ConfigurationElement> getConfigurationElements() {
        return Iterables.concat((Iterable)Iterables.transform(this.keyConfigurations, (Function)new Function<KeyConfiguration, Iterable<ConfigurationElement>>(){

            public Iterable<ConfigurationElement> apply(final KeyConfiguration keyConfiguration) {
                return Iterables.transform(keyConfiguration.getExtractorConfigurations(), (Function)new Function<ExtractConfiguration, ConfigurationElement>(){

                    public ConfigurationElement apply(ExtractConfiguration extractConfiguration) {
                        return new ConfigurationElement(IndexDocumentConfiguration.this.getEntityKey(), keyConfiguration.getPropertyKey(), extractConfiguration.getPath(), extractConfiguration.getType());
                    }
                });
            }
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDocumentConfiguration that = (IndexDocumentConfiguration)o;
        return this.entityKey.equals(that.entityKey) && ((Object)this.keyConfigurations).equals(that.keyConfigurations);
    }

    public int hashCode() {
        return 31 * this.entityKey.hashCode() + ((Object)this.keyConfigurations).hashCode();
    }

    public static class ConfigurationElement {
        private final String entityKey;
        private final String propertyKey;
        private final String path;
        private final Type type;

        public ConfigurationElement(String entityKey, String propertyKey, String path, Type type) {
            this.entityKey = entityKey;
            this.propertyKey = propertyKey;
            this.path = path;
            this.type = type;
        }

        public String getEntityKey() {
            return this.entityKey;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public String getPath() {
            return this.path;
        }

        public Type getType() {
            return this.type;
        }
    }

    @ExperimentalApi
    public static class ExtractConfiguration {
        private final String path;
        private final Type type;

        public ExtractConfiguration(String path, Type type) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        }

        public String getPath() {
            return this.path;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtractConfiguration that = (ExtractConfiguration)o;
            return this.path.equals(that.path) && this.type == that.type;
        }

        public int hashCode() {
            return 31 * this.path.hashCode() + this.type.hashCode();
        }
    }

    @ExperimentalApi
    public static class KeyConfiguration {
        private final List<ExtractConfiguration> extractorConfigurations;
        private final String propertyKey;

        public KeyConfiguration(String propertyKey, List<ExtractConfiguration> extractorConfigurations) {
            this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey, (Object)"propertyKey");
            this.extractorConfigurations = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(extractorConfigurations, (Object)"extractorConfigurations")));
        }

        public List<ExtractConfiguration> getExtractorConfigurations() {
            return this.extractorConfigurations;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyConfiguration that = (KeyConfiguration)o;
            return this.propertyKey.equals(that.propertyKey) && ((Object)this.extractorConfigurations).equals(that.extractorConfigurations);
        }

        public int hashCode() {
            return 31 * this.propertyKey.hashCode() + ((Object)this.extractorConfigurations).hashCode();
        }
    }

    @ExperimentalApi
    public static enum Type {
        NUMBER,
        TEXT,
        STRING,
        DATE;


        public static Option<Type> getValue(String value) {
            try {
                Type type = Type.valueOf(StringUtils.upperCase((String)value));
                return Option.some((Object)((Object)type));
            }
            catch (IllegalArgumentException ignore) {
                return Option.none();
            }
        }
    }
}

