/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.FieldTooLongJsonPropertyException;
import com.atlassian.jira.entity.property.InvalidJsonPropertyException;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public class BaseEntityPropertyService<E extends WithId>
implements EntityPropertyService<E> {
    private final EntityPropertyHelper<E> entityPropertyHelper;
    private final EventPublisher eventPublisher;
    private final I18nHelper i18n;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final String dbEntityName;

    public BaseEntityPropertyService(JsonEntityPropertyManager jsonEntityPropertyManager, I18nHelper i18n, EventPublisher eventPublisher, EntityPropertyHelper<E> entityPropertyHelper) {
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
        this.dbEntityName = entityPropertyHelper.getEntityPropertyType().getDbEntityName();
        this.entityPropertyHelper = entityPropertyHelper;
    }

    @Override
    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, Long entityId, EntityPropertyService.PropertyInput propertyInput) {
        return this.validateSetProperty(user, this.getEntity(entityId), propertyInput);
    }

    protected EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, Option<E> entity, EntityPropertyService.PropertyInput propertyInput) {
        Preconditions.checkNotNull((Object)propertyInput);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.entityPropertyHelper.hasEditPermissionFunction(), errorCollection)) {
            if (StringUtils.isEmpty((CharSequence)propertyInput.getPropertyValue())) {
                errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.empty.value"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else {
                try {
                    this.jsonEntityPropertyManager.putDryRun(this.dbEntityName, ((WithId)entity.get()).getId(), propertyInput.getPropertyKey(), propertyInput.getPropertyValue());
                }
                catch (InvalidJsonPropertyException ex) {
                    errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.invalid.json", propertyInput.getPropertyValue()), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                catch (FieldTooLongJsonPropertyException ex) {
                    errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.too.long.value", String.valueOf(ex.getMaximumLength()), String.valueOf(ex.getActualLength())), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            }
        }
        Option property = errorCollection.hasAnyErrors() ? Option.none() : Option.some((Object)this.createInputForPropertySet((WithId)entity.get(), propertyInput));
        return new EntityPropertyService.SetPropertyValidationResult(errorCollection, (Option<EntityPropertyService.EntityPropertyInput>)property);
    }

    @Override
    public EntityPropertyService.PropertyResult setProperty(ApplicationUser user, @NotNull EntityPropertyService.SetPropertyValidationResult propertyValidationResult) {
        Preconditions.checkNotNull((Object)propertyValidationResult);
        Preconditions.checkNotNull(propertyValidationResult.getEntityPropertyInput());
        Preconditions.checkArgument((boolean)propertyValidationResult.isValid());
        Preconditions.checkArgument((boolean)propertyValidationResult.getEntityPropertyInput().isDefined());
        EntityPropertyService.EntityPropertyInput entityProperty = (EntityPropertyService.EntityPropertyInput)propertyValidationResult.getEntityPropertyInput().get();
        this.jsonEntityPropertyManager.put(this.dbEntityName, entityProperty.getEntityId(), entityProperty.getPropertyKey(), entityProperty.getPropertyValue());
        EntityPropertyService.PropertyResult property = this.getProperty(user, entityProperty.getEntityId(), entityProperty.getPropertyKey());
        if (property.isValid() && property.getEntityProperty().isDefined()) {
            this.eventPublisher.publish(this.entityPropertyHelper.createSetPropertyEventFunction().apply((Object)user, property.getEntityProperty().get()));
        }
        return property;
    }

    @Override
    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, Long entityId, String propertyKey) {
        return this.validateDeleteProperty(user, this.getEntity(entityId), propertyKey);
    }

    protected EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, Option<E> entity, final @NotNull String propertyKey) {
        Preconditions.checkNotNull((Object)propertyKey);
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.entityPropertyHelper.hasEditPermissionFunction(), errorCollection)) {
            EntityPropertyService.PropertyResult property = this.getProperty(user, entity, propertyKey);
            return (EntityPropertyService.DeletePropertyValidationResult)property.getEntityProperty().fold((Supplier)new Supplier<EntityPropertyService.DeletePropertyValidationResult>(){

                public EntityPropertyService.DeletePropertyValidationResult get() {
                    errorCollection.addErrorMessage(BaseEntityPropertyService.this.i18n.getText("jira.properties.service.property.does.not.exist", propertyKey), ErrorCollection.Reason.NOT_FOUND);
                    return new EntityPropertyService.DeletePropertyValidationResult(errorCollection, (Option<EntityProperty>)Option.none());
                }
            }, (Function)new Function<EntityProperty, EntityPropertyService.DeletePropertyValidationResult>(){

                public EntityPropertyService.DeletePropertyValidationResult apply(EntityProperty entityProperty) {
                    return new EntityPropertyService.DeletePropertyValidationResult(errorCollection, (Option<EntityProperty>)Option.some((Object)entityProperty));
                }
            });
        }
        return new EntityPropertyService.DeletePropertyValidationResult(errorCollection, (Option<EntityProperty>)Option.none());
    }

    @Override
    public void deleteProperty(ApplicationUser user, @NotNull EntityPropertyService.DeletePropertyValidationResult validationResult) {
        Preconditions.checkNotNull((Object)validationResult);
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkNotNull(validationResult.getEntityProperty());
        Preconditions.checkArgument((boolean)validationResult.getEntityProperty().isDefined());
        EntityProperty entityProperty = (EntityProperty)validationResult.getEntityProperty().get();
        this.jsonEntityPropertyManager.delete(this.dbEntityName, entityProperty.getEntityId(), entityProperty.getKey());
        this.eventPublisher.publish(this.entityPropertyHelper.createDeletePropertyEventFunction().apply((Object)user, (Object)entityProperty));
    }

    @Override
    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, Long entityId, String propertyKey) {
        return this.getProperty(user, this.getEntity(entityId), propertyKey);
    }

    protected EntityPropertyService.PropertyResult getProperty(ApplicationUser user, Option<E> entity, @NotNull String propertyKey) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.entityPropertyHelper.hasReadPermissionFunction(), errorCollection)) {
            EntityProperty entityProperty = this.jsonEntityPropertyManager.get(this.dbEntityName, ((WithId)entity.get()).getId(), propertyKey);
            return new EntityPropertyService.PropertyResult(errorCollection, (Option<EntityProperty>)Option.option((Object)entityProperty));
        }
        return new EntityPropertyService.PropertyResult(errorCollection, (Option<EntityProperty>)Option.none());
    }

    @Override
    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, Long entityId) {
        return this.getPropertiesKeys(user, this.getEntity(entityId));
    }

    protected EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, Option<E> entity) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.entityPropertyHelper.hasReadPermissionFunction(), errorCollection)) {
            List<String> keys = this.jsonEntityPropertyManager.findKeys(this.dbEntityName, ((WithId)entity.get()).getId());
            return new EntityPropertyService.PropertyKeys<Object>(errorCollection, keys, entity.get());
        }
        return new EntityPropertyService.PropertyKeys<Object>(errorCollection, Collections.<String>emptyList(), null);
    }

    private boolean checkEntity(Option<E> entity, final ApplicationUser user, final EntityPropertyHelper.CheckPermissionFunction<E> permissionFunction, final SimpleErrorCollection errorCollection) {
        return (Boolean)entity.fold((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                errorCollection.addErrorMessage(BaseEntityPropertyService.this.i18n.getText("jira.properties.service.entity.does.not.exist", BaseEntityPropertyService.this.i18n.getText(BaseEntityPropertyService.this.entityPropertyHelper.getEntityPropertyType().getI18nKeyForEntityName())), ErrorCollection.Reason.NOT_FOUND);
                return false;
            }
        }, new Function<E, Boolean>(){

            public Boolean apply(E input) {
                ErrorCollection permissionCheckResults = (ErrorCollection)permissionFunction.apply(user, input);
                if (permissionCheckResults.hasAnyErrors()) {
                    errorCollection.addErrorCollection(permissionCheckResults);
                }
                return !permissionCheckResults.hasAnyErrors();
            }
        });
    }

    private EntityPropertyService.EntityPropertyInput createInputForPropertySet(E entity, EntityPropertyService.PropertyInput propertyInput) {
        return new EntityPropertyService.EntityPropertyInput(propertyInput.getPropertyValue(), propertyInput.getPropertyKey(), entity.getId(), this.dbEntityName);
    }

    private Option<E> getEntity(Long entityId) {
        return (Option)this.entityPropertyHelper.getEntityByIdFunction().apply((Object)entityId);
    }
}

