/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordRequest {
    private final AuditingCategory category;
    private final String summary;
    private final ApplicationUser author;
    private final String remoteAddress;
    private AssociatedItem objectItem;
    private ImmutableList<AssociatedItem> associatedItems;
    private ImmutableList<ChangedValue> changedValues;

    public RecordRequest(@Nonnull AuditingCategory category, @Nonnull String summary, @Nullable ApplicationUser author, @Nullable String remoteAddress) {
        this.category = category;
        this.summary = this.getI18n().getText(summary);
        this.author = author;
        this.remoteAddress = remoteAddress;
    }

    public RecordRequest(@Nonnull AuditingCategory category, @Nonnull String summary) {
        this(category, summary, null, null);
    }

    public RecordRequest forObject(@Nonnull AssociatedItem item) {
        this.objectItem = item;
        return this;
    }

    public RecordRequest forObject(final @Nonnull AssociatedItem.Type type, final @Nonnull String name, final @Nullable String id) {
        this.objectItem = new AssociatedItem(){

            @Override
            @Nonnull
            public String getObjectName() {
                return name;
            }

            @Override
            @Nullable
            public String getObjectId() {
                return id;
            }

            @Override
            @Nullable
            public String getParentName() {
                return null;
            }

            @Override
            @Nullable
            public String getParentId() {
                return null;
            }

            @Override
            @Nonnull
            public AssociatedItem.Type getObjectType() {
                return type;
            }
        };
        return this;
    }

    public RecordRequest thatAffects(AssociatedItem ... items) {
        this.associatedItems = ImmutableList.copyOf((Object[])items);
        return this;
    }

    public RecordRequest thatAffects(@Nonnull Iterable<AssociatedItem> items) {
        this.associatedItems = ImmutableList.copyOf(items);
        return this;
    }

    public RecordRequest withChangedValues(ChangedValue ... values) {
        this.changedValues = ImmutableList.copyOf((Object[])values);
        return this;
    }

    public RecordRequest withChangedValues(@Nonnull Iterable<ChangedValue> values) {
        this.changedValues = ImmutableList.copyOf(values);
        return this;
    }

    @Nonnull
    public AuditingCategory getCategory() {
        return this.category;
    }

    @Nonnull
    public String getSummary() {
        return this.summary;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return this.author;
    }

    @Nullable
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public ImmutableList<AssociatedItem> getAssociatedItems() {
        return this.associatedItems;
    }

    public ImmutableList<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    @Nullable
    public AssociatedItem getObjectItem() {
        return this.objectItem;
    }

    protected I18nHelper getI18n() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(Locale.ENGLISH);
    }
}

