/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class UserHistoryItem {
    private static final int VERY_SHORT = 10;
    public static final Type ISSUE = new Type("Issue");
    public static final Type PROJECT = new Type("Project");
    public static final Type JQL_QUERY = new Type("JQLQuery");
    public static final Type ADMIN_PAGE = new Type("AdminPage");
    public static final Type ASSIGNEE = new Type("Assignee");
    public static final Type USED_USER = new Type("UsedUser");
    public static final Type DASHBOARD = new Type("Dashboard");
    public static final Type ISSUELINKTYPE = new Type("IssueLink");
    public static final Type RESOLUTION = new Type("Resolution");
    public static final Type ISSUESEARCHER = new Type("Searcher");
    private static final Map<String, Type> KNOWN_TYPES;
    public static final Function<UserHistoryItem, String> GET_ENTITY_ID;
    private final long lastViewed;
    private final Type type;
    private final String entityId;
    private final String data;

    public UserHistoryItem(Type type, String entityId, long lastViewed, String data) {
        Assertions.notNull("type", type);
        Assertions.notNull("entityId", entityId);
        Assertions.notNull("lastViewed", lastViewed);
        this.type = type;
        this.entityId = entityId;
        this.lastViewed = lastViewed;
        this.data = data;
    }

    public UserHistoryItem(Type type, String entityId, long lastViewed) {
        this(type, entityId, lastViewed, null);
    }

    public UserHistoryItem(Type type, String entityId) {
        this(type, entityId, System.currentTimeMillis());
    }

    public UserHistoryItem(Type type, String entityId, String data) {
        this(type, entityId, System.currentTimeMillis(), data);
    }

    public long getLastViewed() {
        return this.lastViewed;
    }

    public Type getType() {
        return this.type;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserHistoryItem that = (UserHistoryItem)o;
        if (!this.entityId.equals(that.entityId)) {
            return false;
        }
        if (this.lastViewed != that.lastViewed) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = Long.valueOf(this.lastViewed).hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public String toString() {
        return "UserHistoryItem{type=" + this.type + ", entityId='" + this.entityId + '\'' + ", lastViewed=" + this.lastViewed + '}';
    }

    static {
        HashMap<String, Type> types = new HashMap<String, Type>();
        types.put(ISSUE.getName(), ISSUE);
        types.put(PROJECT.getName(), PROJECT);
        types.put(JQL_QUERY.getName(), JQL_QUERY);
        types.put(ADMIN_PAGE.getName(), ADMIN_PAGE);
        types.put(ASSIGNEE.getName(), ASSIGNEE);
        types.put(USED_USER.getName(), USED_USER);
        types.put(DASHBOARD.getName(), DASHBOARD);
        types.put(ISSUELINKTYPE.getName(), ISSUELINKTYPE);
        types.put(RESOLUTION.getName(), RESOLUTION);
        types.put(ISSUESEARCHER.getName(), ISSUESEARCHER);
        KNOWN_TYPES = Collections.unmodifiableMap(types);
        GET_ENTITY_ID = new Function<UserHistoryItem, String>(){

            public String apply(@Nullable UserHistoryItem input) {
                return input == null ? null : input.getEntityId();
            }
        };
    }

    public static class Type {
        private final String name;

        public Type(String name) {
            Assertions.notBlank("name", name);
            Assertions.is("name", name.length() <= 10);
            this.name = name;
        }

        public static Type getInstance(String name) {
            Type type = (Type)KNOWN_TYPES.get(name);
            if (type != null) {
                return type;
            }
            return new Type(name);
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type other = (Type)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }
    }
}

