/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;

public class NavigatorStructureChecker<T> {
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final JqlOperandResolver operandResolver;
    private final boolean supportMultiLevelFunctions;
    private final ClauseNames clauseNames;

    public NavigatorStructureChecker(ClauseNames clauseNames, boolean supportMultiLevelFunctions, FieldFlagOperandRegistry fieldFlagOperandRegistry, JqlOperandResolver operandResolver) {
        this.supportMultiLevelFunctions = supportMultiLevelFunctions;
        this.clauseNames = Assertions.notNull("clauseNames", clauseNames);
        this.fieldFlagOperandRegistry = Assertions.notNull("fieldFlagOperandRegistry", fieldFlagOperandRegistry);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    @Deprecated
    public NavigatorStructureChecker(ClauseNames clauseNames, boolean supportMultiLevelFunctions, FieldFlagOperandRegistry fieldFlagOperandRegistry, JqlOperandResolver operandResolver, IndexInfoResolver<T> indexInfoResolver, SearchContextVisibilityChecker searchContextVisibilityChecker) {
        this(clauseNames, supportMultiLevelFunctions, fieldFlagOperandRegistry, operandResolver);
    }

    public boolean checkSearchRequest(Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            Clause whereClause = query.getWhereClause();
            SimpleNavigatorCollectorVisitor collector = this.createSimpleNavigatorCollectorVisitor();
            whereClause.accept(collector);
            if (!collector.isValid() || collector.getClauses().size() > 1) {
                return false;
            }
            if (collector.getClauses().size() == 1) {
                TerminalClause terminalClause = collector.getClauses().get(0);
                return this.checkOperator(terminalClause.getOperator()) && this.checkOperand(terminalClause.getOperand(), true, searchContext);
            }
        }
        return true;
    }

    boolean checkOperator(Operator operator) {
        switch (operator) {
            case EQUALS: 
            case IN: 
            case IS: {
                return true;
            }
        }
        return false;
    }

    boolean checkOperand(Operand operand, boolean acceptFunctions, SearchContext searchContext) {
        if (this.isEmptyOperand(operand) || operand instanceof SingleValueOperand) {
            if (this.fieldFlagOperandRegistry.getFlagForOperand(this.clauseNames.getPrimaryName(), operand) != null) {
                return true;
            }
            return operand instanceof SingleValueOperand;
        }
        if (operand instanceof FunctionOperand) {
            return acceptFunctions && this.fieldFlagOperandRegistry.getFlagForOperand(this.clauseNames.getPrimaryName(), operand) != null;
        }
        if (operand instanceof MultiValueOperand) {
            boolean valid = true;
            for (Operand child : ((MultiValueOperand)operand).getValues()) {
                if (this.checkOperand(child, this.supportMultiLevelFunctions, searchContext)) continue;
                valid = false;
                break;
            }
            return valid;
        }
        throw new IllegalArgumentException("Don't know how to validate operand '" + operand + "' for navigator");
    }

    SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectorVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
    }

    private boolean isEmptyOperand(Operand operand) {
        return this.operandResolver.isEmptyOperand(operand);
    }
}

