/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypeImpl;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.customfields.option.CascadingOption;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CommentField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.types.Duration;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public final class JiraDataTypes {
    public static final JiraDataType ISSUE = new JiraDataTypeImpl(Issue.class);
    public static final JiraDataType PROJECT = new JiraDataTypeImpl(Project.class);
    public static final JiraDataType PROJECT_CATEGORY = new JiraDataTypeImpl(ProjectCategory.class);
    public static final JiraDataType VERSION = new JiraDataTypeImpl(Version.class);
    public static final JiraDataType COMPONENT = new JiraDataTypeImpl(ProjectComponent.class);
    public static final JiraDataType USER = new JiraDataTypeImpl(User.class);
    public static final JiraDataType GROUP = new JiraDataTypeImpl(Group.class);
    public static final JiraDataType PROJECT_ROLE = new JiraDataTypeImpl(ProjectRole.class);
    public static final JiraDataType PRIORITY = new JiraDataTypeImpl(Priority.class);
    public static final JiraDataType RESOLUTION = new JiraDataTypeImpl(Resolution.class);
    public static final JiraDataType ISSUE_TYPE = new JiraDataTypeImpl(IssueType.class);
    public static final JiraDataType STATUS = new JiraDataTypeImpl(Status.class);
    public static final JiraDataType CASCADING_OPTION = new JiraDataTypeImpl(CascadingOption.class);
    public static final JiraDataType OPTION = new JiraDataTypeImpl(Option.class);
    public static final JiraDataType SAVED_FILTER = new JiraDataTypeImpl(SearchRequest.class);
    public static final JiraDataType ISSUE_SECURITY_LEVEL = new JiraDataTypeImpl(IssueSecurityLevel.class);
    public static final JiraDataType LABEL = new JiraDataTypeImpl(Label.class);
    public static final JiraDataType ATTACHMENT = new JiraDataTypeImpl(Attachment.class);
    public static final JiraDataType DATE = new JiraDataTypeImpl(Date.class);
    public static final JiraDataType TEXT = new JiraDataTypeImpl(String.class);
    public static final JiraDataType NUMBER = new JiraDataTypeImpl(Number.class);
    public static final JiraDataType DURATION = new JiraDataTypeImpl(Duration.class);
    public static final JiraDataType URL = new JiraDataTypeImpl(URL.class);
    public static final JiraDataType ALL = new JiraDataTypeImpl(Object.class);
    private static final Map<String, JiraDataType> FIELD_MAP = ImmutableMap.builder().put((Object)"project", (Object)PROJECT).put((Object)"versions", (Object)VERSION).put((Object)"assignee", (Object)USER).put((Object)"components", (Object)COMPONENT).put((Object)"comment", (Object)TEXT).put((Object)"description", (Object)TEXT).put((Object)"duedate", (Object)DATE).put((Object)"environment", (Object)TEXT).put((Object)"fixVersions", (Object)VERSION).put((Object)"issuekey", (Object)ISSUE).put((Object)"issuetype", (Object)ISSUE_TYPE).put((Object)"priority", (Object)PRIORITY).put((Object)"reporter", (Object)USER).put((Object)"security", (Object)ISSUE_SECURITY_LEVEL).put((Object)"summary", (Object)TEXT).put((Object)"created", (Object)DATE).put((Object)"updated", (Object)DATE).put((Object)"resolutiondate", (Object)DATE).put((Object)"status", (Object)STATUS).put((Object)"resolution", (Object)RESOLUTION).put((Object)"labels", (Object)LABEL).build();

    public static String getType(Field field) {
        if (field instanceof CommentField) {
            return field.getClass().getCanonicalName();
        }
        JiraDataType dataType = JiraDataTypes.getFieldType(field.getId());
        if (dataType == null) {
            return field.getClass().getCanonicalName();
        }
        Collection<String> stringCollection = dataType.asStrings();
        if (stringCollection.size() == 1) {
            return stringCollection.iterator().next();
        }
        return stringCollection.toString();
    }

    public static String getType(String fieldId) {
        JiraDataType dataType = JiraDataTypes.getFieldType(fieldId);
        if (dataType == null) {
            return fieldId;
        }
        Collection<String> stringCollection = dataType.asStrings();
        if (stringCollection.size() == 1) {
            return stringCollection.iterator().next();
        }
        return stringCollection.toString();
    }

    public static JiraDataType getFieldType(String fieldId) {
        return FIELD_MAP.get(fieldId);
    }
}

