/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MatchHandler;
import java.util.Collections;
import java.util.List;

@ExperimentalApi
public class SingleValueMatchHandler
implements MatchHandler {
    private static final List<String> NULL_SINGLETON = Collections.singletonList(null);
    private final List<String>[] docToTerms;
    private Object previousTermValue = null;
    private List<String> currentSingleton = NULL_SINGLETON;

    public SingleValueMatchHandler(int maxdoc) {
        this.docToTerms = new List[maxdoc];
    }

    @Override
    public void handleMatchedDocument(int doc, String termValue) {
        if (this.previousTermValue != termValue) {
            this.previousTermValue = termValue;
            this.currentSingleton = Collections.singletonList(termValue);
        }
        this.docToTerms[doc] = this.currentSingleton;
    }

    public List<String>[] getResults() {
        return this.docToTerms;
    }
}

