/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.changehistory.ChangeHistoryFieldConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ChangeHistoryFieldIdResolver {
    private static final Collection<String> EMPTY_ID = Collections.singleton("-1");
    private final ChangeHistoryFieldConstants changeHistoryFieldConstants;
    private final UserResolver userResolver;
    private final VersionResolver versionResolver;
    private final ConstantsManager constantsManager;
    private final LazyReference<Map<String, List<String>>> ref = new LazyReference<Map<String, List<String>>>(){

        protected Map<String, List<String>> create() throws Exception {
            return Maps.newHashMap();
        }
    };

    @Deprecated
    public ChangeHistoryFieldIdResolver(ChangeHistoryFieldConstants changeHistoryFieldConstants, VersionResolver versionResolver, ConstantsManager constantsManager) {
        this(changeHistoryFieldConstants, ComponentAccessor.getComponentOfType(UserResolver.class), versionResolver, constantsManager);
    }

    public ChangeHistoryFieldIdResolver(ChangeHistoryFieldConstants changeHistoryFieldConstants, UserResolver userResolver, VersionResolver versionResolver, ConstantsManager constantsManager) {
        this.changeHistoryFieldConstants = changeHistoryFieldConstants;
        this.userResolver = userResolver;
        this.versionResolver = versionResolver;
        this.constantsManager = constantsManager;
    }

    public Collection<String> resolveIdsForField(String field, QueryLiteral literal, boolean emptyOperand) {
        String value;
        String string = value = literal.getLongValue() != null ? literal.getLongValue().toString() : literal.getStringValue();
        if (emptyOperand) {
            return value != null ? Collections.singleton(value) : EMPTY_ID;
        }
        if (this.isConstantField(field)) {
            return this.resolveIdsForConstantField(field, literal, value);
        }
        if (this.isAssigneeOrReporterField(field)) {
            return this.resolveIdsForUserField(value);
        }
        if (this.isVersionField(field)) {
            return this.resolveIdsForVersion(value);
        }
        return Collections.singleton(value);
    }

    private Collection<String> resolveIdsForConstantField(String field, QueryLiteral literal, String value) {
        IssueConstant issueConstant = this.constantsManager.getConstantByNameIgnoreCase(field, value);
        if (issueConstant == null) {
            return this.changeHistoryFieldConstants.getIdsForField(field, literal);
        }
        return Collections.singletonList(issueConstant.getId());
    }

    private Collection<String> resolveIdsForUserField(String rawValue) {
        return this.userResolver.getIdsFromName(rawValue);
    }

    private Collection<String> resolveIdsForVersion(String rawValue) {
        Map map = (Map)this.ref.get();
        List<String> idsPerVersion = (List<String>)map.get(rawValue);
        if (idsPerVersion == null) {
            idsPerVersion = this.versionResolver.getIdsFromName(rawValue);
            map.put(rawValue, idsPerVersion);
        }
        if (idsPerVersion.isEmpty()) {
            return Collections.singleton(rawValue);
        }
        return Sets.newHashSet(idsPerVersion);
    }

    public boolean isConstantField(String field) {
        return this.constantsManager.getConstantObjects(field) != null;
    }

    public boolean isAssigneeOrReporterField(String field) {
        return SystemSearchConstants.forAssignee().getFieldUrlParameter().equalsIgnoreCase(field) || SystemSearchConstants.forReporter().getFieldUrlParameter().equalsIgnoreCase(field);
    }

    public boolean isVersionField(String field) {
        return "fixversion".equalsIgnoreCase(field);
    }
}

